use strict;
use warnings;
use Audio::Wav; # Get this from CPAN

my $samplingFreq = 11000; # In Hz
my $samplingPeriod = ( 1 / $samplingFreq ); # In seconds

my $OUTPUT_AMPLITUDE = 100; # Directly propertional to the "loudness" of the wave (the output wave amplitude)

my $V = ( $OUTPUT_AMPLITUDE / 2 ); # Beginning amplitude

# Perfectly simulates the BTC waveform just as shown by RomanBlack's BTc encoder application
sub V
{
    my ( $BIT_TO_BE_SENT,  $V_INITIAL ) = @_;
    
    return ( $BIT_TO_BE_SENT ? ( $V_INITIAL + (( $OUTPUT_AMPLITUDE - $V_INITIAL) / 8) ) : ( $V_INITIAL - ($V_INITIAL / 8) ) ); # Models rise as well as decay
}

# BTc 8, 1 bit encoded output of the stock 1.wav that comes with the application

# TODO : We need to make RomanBlack's BTc encoder application output the BTc encoded data in this "format", a list of bytes, ( helps to run in a C compiler as well )

my @sound_data =
(0x56,0xAB,0x2B,0x53,0xB0,0x7C,0x3D,0x1B
,0x0D,0x47,0xA0,0xF4,0x7C,0x3C,0x3E,0x1E
,0x4E,0x95,0x55,0x5C,0xA1,0xF0,0x7C,0x3E
,0x1E,0x0E,0x0F,0x87,0x81,0xEF,0xC0,0x17
,0xF7,0x80,0xC7,0xF0,0xF8,0x3A,0x7C,0x1C
,0x1F,0x3C,0x07,0x9F,0x02,0x3F,0x0F,0x0E
,0x2F,0x4F,0x0F,0x07,0x87,0x83,0x87,0xC3
,0x83,0xC3,0xC1,0xE3,0xC3,0xE1,0xCF,0x17
,0xC3,0xE0,0xE1,0xE0,0xE1,0xE0,0xE7,0xE1
,0xF1,0x78,0x7C,0x31,0xF8,0x43,0xC7,0xC1
,0xCD,0xC1,0xC7,0x83,0x8F,0x87,0x47,0xE0
,0xF8,0x72,0xE1,0xC7,0xC1,0xC7,0xC3,0xA7
,0x87,0x8F,0x07,0x27,0x38,0xD0,0x7F,0x40
,0x3E,0x0C,0x7C,0x30,0x7C,0xE0,0xF1,0xE1
,0xE1,0xC7,0xC0,0xBF,0x0D,0x0F,0x3E,0x1C
,0x3C,0x7C,0x70,0xF8,0x3B,0xC3,0xCC,0x0F
,0x3E,0x0C,0xFC,0x20,0xFD,0xC0,0xE6,0xF3
,0x0F,0x06,0x7E,0x08,0xF8,0x63,0xF3,0x80
,0xCF,0x8F,0x0D,0x3C,0x78,0x38,0xF8,0xE1
,0xE1,0xC3,0xC7,0x83,0x0F,0x3C,0x38,0x39
,0xF8,0xC1,0xE7,0xC1,0xA3,0xC6,0xC9,0x70
,0xF0,0xF1,0xE0,0xC7,0xC3,0x0F,0x1E,0x1A
,0x3D,0xC1,0xC3,0xE7,0x03,0x8F,0x86,0x0F
,0x9C,0x0C,0x7E,0x60,0x7B,0xB1,0x0F,0x5C
,0x31,0x75,0x60,0xB2,0xF0,0xC1,0xF7,0x81
,0xCF,0x8D,0x1C,0x5C,0xC8,0xB5,0xC5,0x0B
,0xDA,0x47,0x3F,0x06,0x3E,0x68,0x72,0xE9
,0x52,0xB4,0xB4,0xB2,0xE9,0x4A,0xB7,0x14
,0x8F,0x8B,0x16,0xAC,0x2C,0x74,0x71,0x69
,0xE6,0x45,0xDC,0xA2,0xBA,0xA8,0xD3,0x69
,0x51,0xAA,0xE2,0xC9,0xEA,0x93,0x73,0x91
,0x55,0xCA,0x93,0x95,0x4B,0x2B,0x56,0x36
,0x78,0xAA,0xD9,0x52,0xCB,0x4A,0x96,0x56
,0x55,0x35,0x59,0x55,0x72,0xA9,0xB2,0xA9
,0xAA,0xA9,0x55,0x55,0x55,0x69,0xAA,0xA6
,0xD5,0x4A,0xAB,0x4A,0xAA,0xAA,0x55,0x55
,0x55,0x56,0x6B,0x2A,0xAD,0x4A,0xAD,0x34
,0xAA,0xAA,0x55,0x55,0x6A,0xAA,0xD5,0x55
,0x55,0x55,0x4A,0xB5,0x4A,0xAA,0xAA,0xAB
,0x35,0x55,0x59,0x4D,0x2D,0x54,0xB2,0xAD
,0x52,0xAA,0xAD,0x56,0x59,0x3A,0x6A,0x2C
,0xB2,0xA9,0x6A,0xA8,0xF8,0x3C,0x5C,0x78
,0x58,0xF4,0x79,0x64,0xAB,0x2A,0x98,0xF8
,0x3C,0x1C,0x7C,0x38,0x3E,0x7C,0x38,0x1D
,0xFA,0x14,0x1C,0x7C,0x38,0x1E,0x7C,0x18
,0x1F,0x7E,0x10,0x3F,0x7C,0x08,0x39,0xF8
,0x60,0x7C,0xF8,0x10,0x7E,0xF8,0x01,0x7E
,0x78,0x14,0x3B,0xF0,0x60,0x7D,0xF8,0x02
,0x7F,0xD8,0x02,0x7E,0xF8,0x08,0x79,0xF8
,0x20,0xBC,0xFC,0x04,0x3F,0xEC,0x01,0x3F
,0xEC,0x02,0x7E,0x7C,0x1A,0x1F,0x6E,0x02
,0x8F,0xE7,0x80,0x67,0xF3,0x00,0xD7,0x9F
,0x02,0xC3,0xE9,0xE0,0x71,0xFC,0xE0,0x33
,0xF4,0x68,0x32,0xF3,0xE0,0x59,0x3F,0x1C
,0x07,0x3F,0x91,0x05,0x66,0xF1,0x24,0x77
,0x99,0xA2,0xF0,0xF8,0x74,0x1D,0x7E,0x06
,0x85,0xE3,0xE8,0x32,0x7E,0x1F,0x04,0xF1
,0x79,0xA4,0x19,0x9F,0x4A,0x83,0x67,0xE1
,0x25,0x7D,0x4A,0xA0,0xF9,0x74,0x89,0x8B
,0xE2,0xA6,0xAB,0x66,0x63,0x4B,0xC3,0x62
,0xB8,0x79,0x2D,0x16,0xCB,0x31,0xB4,0xD8
,0x6C,0xAE,0x4E,0x1A,0xA5,0x96,0x53,0x36
,0x72,0x9A,0xD3,0x35,0x99,0x53,0x65,0x4D
,0x48,0xD9,0x72,0x66,0xAB,0x94,0xD9,0x69
,0x59,0x55,0x2C,0xB5,0x2A,0x56,0x9B,0x4A
,0xAD,0x95,0xA5,0x55,0x55,0x53,0x53,0x55
,0x54,0xAA,0xB5,0x55,0x56,0x6A,0xAA,0xA6
,0xAA,0xAA,0xA6,0x55,0x53,0x55,0x55,0x55
,0x96,0x96,0xAA,0xAA,0xAA,0xAA,0x55,0x55
,0x55,0x55,0x55,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0x55,0x2D,0x55,0x55,0x55,0x6A,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0x39,0x8D,0x55
,0x6A,0xAC,0xA6,0xAB,0x59,0x2C,0xCB,0x55
,0x32,0xA9,0xDC,0x26,0xAB,0x99,0xC4,0xB5
,0x72,0xA9,0x5A,0x5A,0x8A,0xA8,0xEE,0x17
,0x33,0x95,0xC4,0x73,0x3A,0x35,0x2B,0x25
,0x95,0x61,0xDC,0x2E,0x57,0x23,0xC8,0xBC
,0x5E,0x4B,0x31,0x68,0x79,0x87,0xE0,0x7C
,0x3E,0x07,0x83,0xF1,0xF0,0x3C,0x78,0x3C
,0x1E,0x77,0x03,0xD3,0xE0,0x38,0x7E,0x0E
,0x07,0xE3,0xC1,0xF0,0xF8,0x7C,0x0F,0x87
,0xC1,0xE1,0xF8,0x3C,0x7C,0x1F,0x07,0xC3
,0xE0,0xFC,0x1F,0x0F,0x03,0xC3,0xE0,0xF0
,0xF0,0x7C,0x1F,0x07,0xC1,0xF0,0x7C,0x3C
,0x0F,0x87,0x87,0xC3,0xE0,0xF8,0x3C,0x1F
,0x87,0xC0,0xF8,0xF0,0x3E,0x3C,0x1E,0x0F
,0x03,0xE0,0xF0,0x7E,0x3F,0x07,0xC7,0xC1
,0xE1,0xE0,0xF0,0xF8,0x3E,0x07,0xC1,0xF1
,0xF0,0x7C,0x78,0x1C,0x7E,0x1F,0x0F,0x06
,0x78,0x1E,0x0F,0x3E,0x07,0x4F,0x83,0x87
,0xC3,0x0F,0xCE,0x07,0xC3,0xE3,0x83,0xE0
,0xE3,0xF1,0x80,0xF7,0xC1,0xC3,0xE1,0x38
,0x5E,0x78,0x1F,0x07,0x1B,0xAC,0x30,0x7E
,0x8E,0x1B,0x03,0xE3,0xC3,0x47,0x9E,0x47
,0x1B,0x86,0xE1,0xD8,0x74,0x78,0x9C,0x3B
,0x30,0xDC,0xD1,0x3D,0x34,0xA7,0x2D,0x86
,0x3D,0x4E,0x0F,0x4F,0x07,0x1F,0x0B,0x1E
,0x97,0x0E,0x5E,0x15,0x2D,0x51,0x55,0x78
,0xA8,0xF5,0x61,0xE4,0xF0,0xD0,0xF4,0xD0
,0xE9,0x6A,0x35,0x9A,0xA7,0x1D,0x1E,0x55
,0x1E,0x4B,0x1D,0x26,0x56,0x93,0x55,0x5A
,0x69,0x59,0xB4,0x92,0xE9,0xA2,0xD4,0xA6
,0xAA,0x5A,0xAA,0xAD,0x54,0xAE,0xB2,0x4E
,0xAD,0x1A,0x9A,0x5A,0x55,0x6D,0x2A,0xAD
,0x89,0xAB,0x49,0x95,0x65,0x52,0xA6,0xD2
,0xAA,0xE9,0x69,0xB5,0x55,0x66,0x59,0x95
,0x35,0x2A,0x5A,0x9A,0x37,0x2B,0x1A,0xAA
,0xAA,0xAA,0xAB,0x2A,0xAA,0x95,0x5A,0xAA
,0xAD,0x55,0x5A,0xAA,0xAA,0xAA,0x6A,0x54
,0xD4,0xAA,0xAA,0xAA,0xAD,0x53,0x34,0xB5
,0x55,0x4E,0x53,0x4A,0x6A,0xAB,0x32,0xCC
,0xAD,0x4D,0x93,0x4D,0x6A,0x4B,0x34,0xCA
,0x59,0xC6,0xAA,0xAC,0xE3,0x4E,0x55,0x55
,0x34,0xB2,0xAA,0xA6,0x9A,0x74,0x67,0x4D
,0x96,0x56,0xAA,0x69,0xCA,0x4B,0x2D,0x59
,0x26,0x6A,0xD8,0xF1,0x91,0xE3,0xC6,0x83
,0x1B,0xEE,0x0A,0x16,0x7E,0x64,0xC7,0x83
,0xC3,0x9F,0x82,0x0B,0xFD,0x80,0x27,0xF3
,0xC0,0x7B,0x9F,0x03,0x87,0xF0,0xC0,0x7F
,0xB8,0x04,0x9F,0xC3,0x81,0xFB,0x1F,0x03
,0xE4,0xF0,0x19,0x3F,0x82,0x43,0x7C,0xA6
,0x8D,0xE3,0x87,0xC0,0xFC,0x3F,0x03,0xC2
,0xFC,0x0E,0x0F,0xE1,0x70,0x7E,0x87,0xE0
,0x3F,0x0F,0x80,0x7C,0x3F,0x03,0x57,0xE8
,0xAA,0x3F,0x41,0xF0,0x1F,0x83,0xE0,0x2F
,0x2F,0x41,0x56,0xEA,0x5D,0x15,0xD0,0x9F
,0x07,0x88,0xF4,0x9A,0x8D,0xD3,0x39,0xA6
,0x2D,0xD4,0x54,0xAE,0x75,0x0C,0x73,0x92
,0x73,0x1E,0x4D,0xD8,0x96,0x9B,0xA0,0xDA
,0x38,0xE6,0x1C,0xC3,0xBC,0x62,0x9E,0x75
,0x45,0xAD,0x54,0x95,0xAA,0xA4,0x76,0x8E
,0x4B,0xCA,0xB8,0xAE,0x47,0x71,0xAA,0x36
,0x95,0x55,0x5A,0xAB,0x4A,0xB2,0x9D,0x55
,0x44,0xD5,0x55,0x52,0x96,0x69,0x56,0xAC
,0xAB,0xCA,0xA9,0x6B,0x2A,0xB2,0xAA,0x95
,0x55,0x56,0x65,0xAA,0x6A,0xAC,0xAA,0xAA
,0xAA,0x56,0x95,0x55,0x56,0x55,0x65,0xAC
,0xAA,0xAA,0xAA,0xAA,0xAA,0xA9,0x55,0x55
,0x55,0x55,0x5A,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAB,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x2A,0xAA,0xAA
,0xAB,0x55,0x55,0x55,0x55,0x55,0x2A,0xAA
,0x99,0x4B,0x35,0x55,0x56,0xAA,0xAB,0x35
,0x55,0x55,0x55,0x55,0x54,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0x5A,0xA9,0x98
,0xCD,0x65,0x5A,0x66,0xAA,0xAA,0xCC,0xD3
,0x34,0xCC,0xB2,0xA6,0x39,0x9C,0xC7,0x33
,0x4C,0xE5,0x33,0x32,0x66,0xA9,0x95,0x33
,0x53,0x4C,0xD5,0xA6,0xCA,0xB3,0x4C,0xCC
,0xAA,0x66,0x65,0x98,0xD6,0x66,0x6B,0x33
,0x35,0x95,0x35,0x95,0x99,0x54,0xCD,0x36
,0x66,0x59,0xA9,0xAC,0xCC,0xA6,0xC6,0x66
,0x56,0x55,0x33,0x4C,0xD9,0x56,0x65,0xB1
,0x94,0xD5,0x55,0x4C,0xAB,0x2A,0xCC,0xCD
,0x66,0x67,0x59,0x59,0x35,0x4C,0xD5,0x32
,0x94,0xD5,0x56,0x59,0x4D,0x4D,0x5C,0xCE
,0x64,0x71,0xBB,0x4C,0x45,0x39,0xDA,0x66
,0x29,0x9C,0x6E,0x33,0x30,0x67,0x6D,0x8C
,0x13,0x73,0xCE,0x4B,0x0E,0xD9,0xD8,0xCC
,0x99,0x8F,0x39,0x10,0x73,0xCE,0xC6,0x1C
,0x39,0xF3,0x60,0xC3,0x99,0x8F,0x38,0x30
,0x74,0xF7,0xC1,0x87,0x38,0xF3,0x30,0xE1
,0xCD,0xC3,0x9E,0x12,0x3E,0x7A,0x64,0xC5
,0xBE,0x73,0x0C,0x71,0xCC,0xC1,0xCB,0x11
,0x93,0xDF,0x06,0x2E,0x5E,0x38,0xAA,0x1D
,0x3B,0x1C,0x3A,0x64,0x38,0xFD,0x88,0xB3
,0x1F,0x38,0x62,0x19,0xF1,0x60,0x7A,0x78
,0x30,0xFD,0xE8,0x9C,0x38,0xFC,0xCC,0x28
,0xC7,0xC1,0xC1,0xF3,0x70,0x38,0x7E,0x5C
,0x0E,0x13,0xF3,0x30,0x71,0xCF,0x81,0xE0
,0xF8,0xF0,0x1C,0x3F,0x87,0x01,0xE1,0xF0
,0x70,0xD6,0x43,0xF0,0x70,0x7F,0x0F,0x01
,0xD7,0xE9,0x24,0x3C,0x7A,0x8E,0x91,0xCB
,0x1F,0x03,0xC2,0xF8,0x9A,0x0F,0xA3,0xE0
,0x70,0xF6,0x3C,0xCF,0x06,0xA9,0xCF,0x81
,0xE1,0xF8,0x58,0x1F,0x8F,0x81,0xF0,0xF8
,0x3C,0x6E,0x8D,0x83,0xE2,0x7C,0x0F,0x07
,0xC3,0xE0,0xF1,0x7C,0xB5,0x0E,0x1F,0x07
,0xE1,0x90,0xE9,0x7E,0x07,0xC1,0xE0,0xF8
,0xF8,0x1C,0x3E,0x4E,0x13,0x8B,0x5A,0x5D
,0x2B,0x16,0xAB,0x55,0x50,0xF4,0x58,0x79
,0x3C,0x25,0x3B,0x75,0x32,0x6A,0x3D,0x36
,0x4A,0x5A,0x9A,0x95,0x55,0x55,0x5A,0x9D
,0x1A,0xB3,0x1D,0x2A,0x9A,0xAD,0x2A,0x55
,0xAA,0xA9,0xB2,0xD6,0x54,0xD5,0x54,0xB5
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x56,0x6A,0xAA,0xAB,0x2A,0xCB
,0x33,0x4C,0xCB,0x33,0x4C,0xCD,0x63,0x39
,0x8C,0xE6,0x39,0x98,0xCE,0x63,0x39,0x9C
,0xCC,0x67,0x33,0x19,0x9C,0xCC,0xE6,0x73
,0x31,0x99,0x9C,0xCC,0xCE,0x66,0x73,0x33
,0x19,0x99,0x9C,0xCC,0xCC,0xCE,0x66,0x66
,0x66,0x67,0x33,0x33,0x33,0x33,0x36,0x66
,0x66,0x66,0x66,0x66,0x6C,0xCC,0xCC,0xCD
,0x99,0x99,0x99,0x9B,0x33,0x36,0x6C,0xCD
,0x9B,0x32,0x66,0xCD,0x9B,0x36,0x6C,0xD9
,0x36,0x6C,0xD9,0xB2,0x6C,0x9B,0x26,0xC9
,0xB2,0x6C,0x9B,0x64,0xD9,0x36,0xC9,0xB6
,0x4D,0xB6,0x49,0xB6,0xC9,0x36,0xD9,0x2C
,0x9B,0x6D,0x92,0xCB,0x2C,0xD6,0x59,0x66
,0xB2,0x69,0xAC,0x9A,0x69,0x65,0x96,0x6B
,0x2D,0xB2,0xD3,0x6C,0xAC,0xB2,0xCB,0x4D
,0xB2,0x9B,0x49,0xA6,0xB2,0xCB,0x65,0xA6
,0xD2,0x6B,0x2C,0xB6,0x5B,0x4D,0x26,0x9A
,0x4B,0x6C,0xB6,0x9B,0x49,0x65,0xB6,0xD3
,0x6D,0x2D,0xA6,0x92,0xC9,0x6C,0xB6,0xD3
,0x49,0xA5,0xB6,0xCA,0x69,0xAD,0x2C,0xD6
,0x5A,0x69,0x34,0xD6,0x5A,0x6B,0x2D,0x35
,0x56,0x56,0x59,0x65,0xA6,0x9A,0xCB,0x2D
,0x34,0xD2,0xD9,0x69,0xA6,0x96,0x5B,0x2C
,0xB4,0xDA,0x69,0x65,0xA6,0x9A,0x6B,0x2C
,0xB6,0x53,0x4B,0x6C,0xB4,0xDA,0x4B,0x2D
,0xB6,0x9A,0x4B,0x65,0xB4,0x92,0xCB,0x69
,0xA6,0x96,0x59,0x6D,0x34,0x9A,0x59,0x69
,0xA6,0x96,0xCA,0xCD,0x34,0xB6,0x9A,0x69
,0xA6,0x96,0x55,0x55,0x35,0x55,0x56,0x65
,0xAA,0xAA,0xAA,0xAA,0xAA,0x9A,0xAA,0xAA
,0xB2,0xAA,0xAA,0x9A,0xAA,0x6A,0xAA,0xAA
,0xD3,0x55,0x55,0x55,0x55,0x4D,0x2A,0xAA
,0xCB,0x55,0x55,0x56,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x54,0xAA,0x99,0xB2,0x6C
,0x9B,0x26,0xD9,0x36,0x4D,0x93,0x64,0xD9
,0x36,0xC9,0xB3,0x64,0xD9,0x36,0x4D,0x93
,0x64,0xD9,0x36,0x4D,0xB2,0x6C,0x9B,0x26
,0xC9,0xB2,0x6C,0x9B,0x26,0xC9,0xB2,0x6C
,0x9B,0x26,0xD9,0x36,0x4D,0x93,0x64,0xD9
,0x36,0x6C,0x9B,0x64,0xD9,0xB2,0x6C,0x9B
,0x26,0xC9,0xB2,0x6D,0x93,0x66,0xC9,0xB6
,0x4D,0x93,0x64,0xD9,0x36,0x4D,0x93,0x64
,0xD9,0x36,0x4D,0x93,0x64,0xD9,0x36,0x4D
,0x93,0x64,0xD9,0x36,0x4D,0x93,0x64,0xD9
,0x36,0x59,0xB2,0x6C,0x9B,0x26,0xCB,0x32
,0x6C,0xB3,0x2C,0xCB,0x32,0xCC,0xB3,0x4C
,0xD3,0x34,0xCD,0x32,0xCC,0xB3,0x26,0x99
,0x96,0x69,0x9A,0x66,0xAA,0xAA,0xAA,0x9A
,0x65,0x55,0x55,0x4D,0x55,0x55,0x59,0xA6
,0x65,0x95,0x55,0x4D,0x32,0xAA,0x99,0x65
,0x55,0x55,0x54,0xD5,0x55,0x55,0x53,0x4C
,0xD5,0x32,0xAA,0xAA,0xA6,0x55,0x55,0x54
,0xD5,0x66,0x61,0xCE,0x38,0xC7,0x1C,0xE3
,0x8C,0x71,0xCE,0x38,0xE7,0x1C,0x63,0x8E
,0x71,0xC6,0x38,0xE7,0x1C,0x63,0x8E,0x31
,0xC6,0x38,0xC7,0x38,0xE7,0x18,0xE7,0x18
,0xE7,0x18,0xE3,0x1C,0xE3,0x8E,0x71,0x8E
,0x38,0xC7,0x1C,0xE3,0x8C,0x71,0xCE,0x38
,0xC7,0x18,0xE3,0x9C,0x71,0xC6,0x38,0xE3
,0x8E,0x38,0xC7,0x1C,0x71,0xC7,0x1C,0x71
,0xC6,0x38,0xE3,0x9C,0x71,0xC6,0x38,0xC7
,0x1C,0xE3,0x9C,0x71,0x8E,0x31,0xC7,0x38
,0xE3,0x1C,0x73,0x8E,0x31,0xC7,0x18,0xE3
,0x8C,0x71,0xC6,0x38,0xE7,0x19,0x65,0x96
,0x69,0xA6,0x59,0x66,0x9A,0x6A,0x96,0x69
,0x55,0x55,0x55,0x55,0x56,0x69,0xA6,0x59
,0x65,0x99,0x65,0x96,0x35,0x65,0x9A,0x69
,0xC7,0x1C,0x6E,0x2D,0xC1,0xCC,0xD9,0x2D
,0x31,0xAC,0xCD,0x31,0xD8,0xD9,0x1F,0x19
,0x9B,0x25,0x96,0x35,0xC9,0xA3,0x93,0xC3
,0xB0,0x79,0x9B,0x34,0xB2,0x74,0x99,0x96
,0x3A,0x36,0x47,0xC3,0x33,0x66,0x96,0xA5
,0x93,0x34,0xE3,0x69,0x72,0x3C,0x66,0xCC
,0xAA,0x9D,0x26,0x67,0x8E,0x4F,0x0E,0xE1
,0xCC,0xD9,0x2A,0xA9,0x6C,0xCD,0x31,0xD9
,0x72,0x3E,0x19,0x93,0x2D,0x66,0x2D,0x1B
,0x26,0x36,0x8F,0x81,0xF3,0x32,0x65,0x36
,0xC9,0xB3,0x34,0xE2,0x74,0x6E,0x0E,0x66
,0xCD,0x65,0x59,0x66,0x65,0x8E,0x8F,0x23
,0xF0,0xCC,0x9B,0x1C,0xB2,0xD9,0x99,0x39
,0x70,0xFC,0x0F,0x19,0xB2,0x73,0x2E,0x53
,0x33,0x4E,0x27,0x46,0xE0,0xE6,0x6C,0xDA
,0x69,0xD2,0x66,0x6C,0x68,0xB9,0x1F,0x0C
,0xCD,0x92,0xD5,0x33,0x66,0x49,0xCB,0x91
,0xE8,0x78,0xCD,0x9A,0x59,0x75,0x33,0x31
,0xE3,0x63,0x68,0x78,0xCC,0xD9,0xA5,0xA9
,0x26,0x6D,0x1C,0x5B,0x1E,0x8F,0x33,0x36
,0x69,0x55,0xA3,0x66,0x5C,0x3C,0x5E,0x1C
,0x33,0x36,0x65,0xA5,0xA6,0x6C,0xD8,0xC7
,0x61,0xC3,0x9C,0xCD,0x93,0x4D,0x3B,0x26
,0x78,0xE3,0xC7,0x87,0x19,0xCD,0x9B,0x2C
,0xB2,0x4C,0xCB,0x9C,0x71,0xE3,0x8E,0x66
,0x6C,0xD9,0x36,0xCC,0xCC,0x9C,0xE3,0x8E
,0x31,0x99,0x99,0x9B,0x32,0x66,0x67,0x1C
,0xE3,0x8C,0x73,0x99,0x99,0x99,0x99,0x99
,0x99,0xC7,0x38,0xC7,0x33,0x8C,0xCC,0xCC
,0xCC,0xCC,0xE6,0x39,0xCE,0x71,0x9C,0xC6
,0x63,0x33,0x33,0x33,0x33,0x2C,0xA7,0x32
,0xCD,0x95,0xAA,0x66,0x69,0xA6,0x99,0x99
,0x9A,0xAA,0x6A,0x73,0x2A,0xAA,0x99,0x66
,0xAC,0xA7,0x33,0x2C,0xAA,0xCA,0xAA,0xA6
,0x96,0x39,0x59,0x99,0x99,0xA6,0x66,0xA6
,0xA7,0x2A,0x99,0x65,0x55,0x54,0xD5,0x53
,0x35,0x9A,0xB1,0xAA,0xAA,0xA6,0x9A,0xA9
,0xAA,0xAA,0xAC,0xB2,0xCC,0xCD,0x55,0x55
,0x55,0x55,0x96,0x55,0x55,0x58,0xC7,0x18
,0xE3,0x1C,0x73,0x8E,0x31,0xC7,0x38,0xE3
,0x1C,0x63,0x8E,0x71,0xC6,0x38,0xE7,0x1C
,0x63,0x8C,0x71,0xCE,0x38,0xC7,0x1C,0xE3
,0x8C,0x71,0x8E,0x39,0xC7,0x18,0xE3,0x9C
,0x73,0x8E,0x71,0xC6,0x38,0xE3,0x1C,0x73
,0x8E,0x31,0xC6,0x38,0xE7,0x1C,0xE3,0x8C
,0x71,0xC6,0x38,0xE7,0x1C,0x63,0x8E,0x71
,0xC6,0x38,0xE7,0x1C,0xE3,0x8C,0x71,0xCE
,0x39,0xC7,0x18,0xE3,0x9C,0x73,0x8E,0x31
,0xC7,0x38,0xE3,0x1C,0x73,0x8E,0x71,0xC6
,0x38,0xC7,0x1C,0xE3,0x9C,0x71,0x8E,0x39
,0xC7,0x38,0xE3,0x1C,0x73,0x8E,0x71,0xC6
,0x39,0xC7,0x19,0x66,0x9A,0x69,0x96,0x59
,0xA6,0x9A,0xCB,0x2C,0xD3,0x95,0x32,0xCB
,0x32,0xCB,0x2C,0xD3,0x8E,0x69,0xA6,0x59
,0x66,0x9A,0x69,0x96,0x69,0xA6,0x59,0x66
,0x9A,0x65,0x96,0x69,0x96,0x59,0xC7,0x39
,0x99,0x99,0x99,0x98,0xCC,0xCC,0xCC,0x66
,0x66,0x63,0x33,0x33,0x39,0x99,0x99,0xCC
,0xCC,0xCC,0x66,0x66,0x67,0x33,0x33,0x19
,0x99,0x99,0xCC,0xCC,0xCC,0x66,0x66,0x67
,0x33,0x33,0x31,0x99,0x99,0x9C,0xCC,0xCC
,0xCE,0x66,0x66,0x67,0x33,0x33,0x39,0x99
,0x99,0x98,0xCC,0xCC,0xCC,0xE6,0x66,0x66
,0x33,0x33,0x33,0x39,0x99,0x99,0x8C,0xCC
,0xCC,0xCE,0x66,0x66,0x63,0x33,0x33,0x31
,0x99,0x99,0x9C,0xCC,0xCC,0xCE,0x66,0x66
,0x67,0x33,0x33,0x35,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x99,0x99,0x9A,0xAA
,0xAA,0xAA,0xAA,0x66,0x66,0x6A,0xAA,0xAA
,0xAA,0xAA,0xAA,0xCC,0xCC,0xCD,0x55,0x55
,0x55,0x55,0x55,0x59,0x99,0x99,0x9A,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xCC,0xCC,0xCD,0x55,0x55,0x55,0x33,0x53
,0x55,0x55,0x99,0x95,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x66,0x66,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAB,0x26,0x73,0x33,0x31,0x99
,0x98,0xCC,0xCC,0x66,0x66,0x63,0x33,0x33
,0x19,0x98,0xCC,0xCC,0x66,0x66,0x33,0x33
,0x19,0x99,0x98,0xCC,0xCC,0x66,0x66,0x33
,0x33,0x19,0x99,0x8C,0xCC,0xCE,0x66,0x66
,0x33,0x33,0x99,0x99,0x8C,0xCC,0xCE,0x66
,0x63,0x33,0x33,0x19,0x99,0x9C,0xCC,0xCE
,0x66,0x66,0x33,0x33,0x39,0x99,0x98,0xCC
,0xCC,0xE6,0x66,0x63,0x33,0x33,0x99,0x99
,0x8C,0xCC,0xCC,0xE6,0x66,0x73,0x33,0x33
,0x99,0x99,0xCC,0xCC,0xCE,0x66,0x67,0x33
,0x33,0x19,0x99,0xCC,0xCC,0xCE,0x66,0x67
,0x33,0x33,0x99,0x99,0x8C,0xCC,0xC6,0x66
,0x73,0x33,0x39,0x99,0x99,0xCC,0xCC,0x66
,0x66,0x73,0x33,0x39,0x99,0x9C,0xCC,0xCC
,0xE6,0x66,0x73,0x33,0x33,0x99,0x99,0x9C
,0xCC,0xCE,0x66,0x66,0xB3,0x33,0x55,0x99
,0xAA,0xAA,0xAA,0xCA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xCC,0xCD,0x66,0x66,0x66,0xB3
,0x33,0x32,0xAC,0xCC,0xCC,0xD5,0x55,0x55
,0x55,0x99,0x99,0x9A,0xAA,0xAA,0xAA,0xB3
,0x33,0x55,0x99,0x99,0xAA,0xAA,0xAA,0xAB
,0x33,0x35,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x9A,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xB5,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x56,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xB5,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x6A
,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xC6,0x67
,0x31,0x8C,0xE6,0x33,0x98,0xCE,0x63,0x19
,0x8C,0xE6,0x31,0x98,0xCE,0x63,0x39,0x8C
,0xE6,0x33,0x98,0xCE,0x63,0x39,0x8C,0x67
,0x31,0x9C,0xC6,0x73,0x19,0xCC,0x67,0x31
,0x9C,0xC6,0x73,0x19,0xCC,0x67,0x31,0x9C
,0xC6,0x73,0x19,0xCC,0x67,0x31,0x9C,0xC6
,0x73,0x19,0xCC,0xE6,0x33,0x98,0xCE,0x63
,0x39,0x8C,0xE6,0x33,0x98,0xCE,0x63,0x39
,0x8C,0xC6,0x73,0x19,0xCC,0xE6,0x33,0x98
,0xCE,0x63,0x31,0x9C,0xC6,0x73,0x39,0x8C
,0xE6,0x33,0x98,0xCE,0x67,0x31,0x9C,0xC6
,0x73,0x19,0x8C,0xE6,0x73,0x19,0xCC,0xE6
,0x73,0x19,0xCC,0x67,0x31,0x99,0xCC,0x6B
,0x33,0x9A,0xCD,0x63,0x39,0x9C,0xC6,0x73
,0x19,0xCC,0xE6,0x33,0x98,0xCE,0x67,0x31
,0x9C,0xC6,0x73,0x39,0x8C,0xE6,0x33,0x98
,0xCE,0x67,0x31,0x9C,0xC6,0x73,0x39,0x8E
,0x67,0x33,0x4C,0xCD,0x33,0x35,0x56,0x66
,0xAA,0xAA,0xCC,0xD5,0x55,0x55,0x55,0x55
,0x55,0x95,0x66,0x6A,0xAA,0xAA,0xAB,0x33
,0x59,0x66,0x66,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xD5,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x66,0xAA
,0xAA,0xAA,0xAA,0xAA,0xCC,0xD5,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x59,0xAA
,0xAB,0x35,0x55,0x50,0x7E,0x23,0x4F,0x12
,0xE0,0x3F,0x88,0xC7,0xCA,0x70,0x2F,0xC4
,0x71,0xF2,0x38,0x1F,0xE1,0x1A,0xF9,0x08
,0x2F,0xE8,0x0F,0xF2,0x01,0x3F,0xE0,0x3F
,0xB4,0x01,0x7F,0xC0,0x3F,0xE8,0x02,0xFF
,0x00,0x7F,0xD0,0x0F,0xFA,0x00,0xFF,0x80
,0x2F,0xF0,0x41,0x7F,0x20,0xA7,0xF4,0x1A
,0x2F,0x86,0x35,0xE2,0x1F,0x80,0xF5,0x8D
,0x39,0x63,0xC0,0x3F,0xA1,0x87,0xD8,0x38
,0x0F,0xD4,0x31,0xF9,0x0E,0x0B,0xF1,0x4C
,0x7C,0x87,0x05,0xF8,0xA6,0x3E,0x43,0x82
,0xFC,0x23,0x9F,0x40,0x23,0xFC,0x06,0xDF
,0x80,0x17,0xFC,0x03,0xFE,0x00,0x5F,0xE0
,0x0B,0xFD,0x00,0xFF,0x80,0x13,0xFE,0x01
,0x7F,0xA0,0x82,0xFC,0x43,0x1F,0xD0,0x58
,0x9F,0x09,0xE3,0x94,0x3E,0x03,0xEA,0xB8
,0x76,0x87,0x80,0xFB,0x46,0x1F,0x91,0xC0
,0x7E,0xC1,0x8F,0xD0,0xA0,0xBF,0x20,0xCF
,0xE0,0x09,0xFF,0x00,0xAF,0xE0,0x0B,0xFE
,0x80,0x7F,0xD0,0x0F,0xF4,0x01,0x7F,0xC0
,0x1F,0xF0,0x21,0x7F,0x60,0x47,0xF8,0x0E
,0x2F,0x83,0x59,0xE4,0x1B,0xC4,0x73,0x76
,0x19,0xC9,0xE0,0x3F,0x64,0x87,0xF0,0x70
,0x1F,0xE0,0x1F,0xF0,0x02,0xFF,0x80,0xBF
,0xD0,0x07,0xFD,0x00,0x7F,0xC0,0x1F,0xF4
,0x07,0x73,0x81,0x3E,0xCC,0x07,0xC8,0x79
,0xBA,0x1D,0x99,0x60,0x3F,0x62,0x63,0xF0
,0x1C,0x47,0xCC,0x63,0xF8,0x0E,0x27,0xF0
,0x33,0xFC,0x00,0xFF,0xA0,0x3F,0xD0,0x0B
,0xFE,0x00,0x7F,0xD0,0x0B,0xFC,0x07,0x72
,0xA3,0x7C,0x0E,0xE3,0xE0,0x3D,0xD8,0x8F
,0xE4,0x0F,0x23,0x8B,0xE8,0xCC,0x6B,0xC0
,0x7D,0xC4,0x1F,0xC0,0x78,0x1F,0x33,0x87
,0xE0,0x3C,0x0F,0xEC,0x23,0xFA,0x08,0x5F
,0xE0,0x37,0xF4,0x03,0xFE,0x80,0x7E,0xA0
,0x2F,0xF8,0x01,0x7F,0x80,0x7F,0xC0,0x3D
,0x87,0x9D,0xC0,0x7F,0x07,0x81,0xF6,0x62
,0x3F,0x90,0x7C,0x0E,0x37,0x81,0xE3,0x8F
,0x01,0xF6,0xC0,0x7F,0x03,0xE0,0x3E,0xCE
,0x0F,0xC1,0x78,0x0F,0xD8,0x83,0xF8,0x38
,0x0F,0xF0,0x27,0xF8,0x02,0xFF,0x60,0x3F
,0xE0,0x0F,0xF4,0x01,0xFF,0x80,0x7F,0xC0
,0x7B,0x1A,0x37,0xC0,0xEF,0x17,0x01,0xF6
,0xC0,0x7F,0x20,0x78,0x1E,0x5F,0x03,0xE7
,0x17,0x03,0xF3,0x20,0xFE,0x03,0xE2,0x3E
,0x6E,0x07,0xC1,0x7C,0x07,0xDC,0x43,0xF8
,0x1E,0x07,0xF8,0x13,0xFC,0x01,0x7F,0xB8
,0x07,0xFC,0x03,0xFE,0x80,0x3F,0xE0,0x1F
,0xE0,0x1F,0xC5,0x0F,0xF0,0x1B,0xE1,0xE0
,0x3F,0x8A,0x0F,0xC4,0x1F,0x03,0xDD,0xC0
,0x7E,0x61,0xE0,0x7E,0x55,0x1F,0x80,0x7E
,0x03,0xEE,0xC0,0xFC,0x07,0xC0,0x7F,0x44
,0x3F,0x80,0xF8,0x1F,0xB1,0x07,0xF0,0x38
,0x0F,0xF0,0x17,0xF8,0x03,0xDF,0x60,0x1F
,0xF0,0x07,0xFD,0x00,0xFF,0x80,0x3F,0xD0
,0x3D,0x9A,0x0F,0xE0,0x4B,0xCB,0x80,0xFF
,0x20,0x3F,0x90,0x3E,0x0F,0x1B,0xC1,0xF1
,0x8F,0x80,0xFB,0x48,0x3F,0x80,0xF8,0x1F
,0x3B,0x03,0xF0,0x5E,0x03,0xFA,0x20,0xFE
,0x07,0xC0,0xFE,0x44,0x3F,0x81,0xC0,0xFF
,0x80,0x7F,0x80,0x2F,0xF6,0x01,0xFF,0x00
,0x7F,0xA0,0x1F,0xF0,0x07,0xFC,0x0E,0x47
,0xC5,0x63,0xF0,0x87,0xE0,0x3D,0xDC,0x0F
,0xE6,0x0F,0x03,0xCC,0xE0,0xFC,0x63,0xE0
,0x3E,0xCC,0x0F,0xE0,0x3E,0x07,0xCE,0xE0
,0x7C,0x47,0xE0,0x3E,0xE6,0x0F,0xE0,0x7C
,0x07,0xEC,0x40,0xFC,0x0F,0x80,0xFD,0x88
,0x3F,0x81,0xF0,0x3F,0xB0,0x17,0xF0,0x38
,0x1F,0xF0,0x07,0xF8,0x02,0xBF,0xD0,0x0F
,0xF8,0x03,0xFC,0x01,0x7F,0x80,0x3F,0xE0
,0x81,0xFE,0xC0,0x3F,0xC4,0x1E,0xC7,0x8C
,0xF0,0xFC,0x0F,0xC4,0x3D,0xCC,0x0F,0xCC
,0x5C,0x07,0xF4,0x81,0xFC,0x05,0xC8,0x7C
,0xCE,0x0F,0xC4,0x7C,0x07,0xEC,0xC0,0xFC
,0x0D,0xC0,0xFD,0x8C,0x1F,0xC0,0xF8,0x0F
,0xD8,0xC3,0xF8,0x1E,0x03,0xFA,0x10,0xFE
,0x07,0x80,0xFE,0x80,0x7F,0x81,0x81,0xFF
,0x40,0x3F,0xC0,0x13,0xFE,0x00,0xFF,0x80
,0x3F,0xC0,0x17,0xFA,0x01,0xFE,0x20,0x1F
,0xF4,0x03,0xFD,0x01,0xD9,0xF8,0x8E,0xBD
,0x01,0xFC,0x07,0x9D,0x81,0xBC,0xC7,0x80
,0xFF,0x80,0x3F,0xC0,0x78,0x1F,0x98,0xC7
,0xF0,0x1F,0x01,0xFB,0x18,0x3F,0x05,0xE0
,0x7F,0x60,0x1F,0xE0,0x70,0x1F,0xE0,0x0B
,0xF8,0x18,0x1F,0xF0,0x07,0xFC,0x01,0x7F
,0xD0,0x0F,0xF8,0x07,0xFA,0x00,0xFF,0x80
,0x5F,0xB8,0x07,0xFC,0x01,0xFE,0x87,0x01
,0xFE,0x80,0x7F,0xA0,0x3D,0x0F,0x33,0xE3
,0xB8,0x1F,0x80,0xFF,0x80,0x3F,0xD0,0x78
,0x1F,0xC8,0x47,0xF4,0x0F,0x81,0xF9,0x8C
,0x3F,0x01,0xF0,0x1F,0xD8,0x87,0xF0,0x1F
,0x03,0xF9,0x08,0xFE,0x03,0xC0,0xFF,0x02
,0x3F,0x81,0xC0,0x7F,0xC0,0x3F,0xE0,0x05
,0xFF,0x40,0x3F,0xE0,0x0F,0xF8,0x03,0xFE
,0x00,0xFF,0x83,0x03,0xFD,0x00,0xFF,0x00
,0x7B,0x1B,0x98,0xCE,0xC8,0x2F,0x80,0xFB
,0x8C,0x3F,0x82,0xF0,0x1F,0xD0,0x17,0xF0
,0x1F,0x03,0xF3,0x14,0xF9,0x07,0xE0,0x3F
,0xA1,0x0F,0xE0,0x3C,0x0F,0xF0,0x07,0xF8
,0x1C,0x27,0xF8,0x03,0xFD,0x00,0xBF,0xD8
,0x07,0xF8,0x02,0xFF,0x00,0x7F,0xC0,0x1F
,0xF0,0x30,0x3F,0xC0,0x8F,0xE0,0x1F,0xA0
,0xBD,0x8C,0x5D,0xC1,0xF8,0x0F,0xF0,0x87
,0xF4,0x07,0xC0,0xFE,0x82,0x7E,0x80,0xF8
,0x1F,0xD4,0x0F,0xE0,0x2F,0x03,0xFD,0x01
,0xFE,0x23,0x19,0xF7,0x00,0xFF,0x40,0x1F
,0xF6,0x01,0xFE,0x00,0xBF,0xD0,0x0F,0xF8
,0x03,0xFE,0x03,0x33,0xE2,0x1D,0xF4,0x02
,0xFB,0x03,0xF1,0x09,0xFE,0x07,0x81,0xFA
,0x84,0xFC,0xA0,0xF9,0x1B,0xF0,0x8D,0xEA
,0x0F,0x03,0xFC,0x21,0xFC,0x21,0xCC,0xFB
,0x80,0x7F,0xA2,0x09,0xFD,0x01,0x7F,0x20
,0x1F,0xF6,0x00,0xFF,0x00,0xFF,0xA0,0x1F
,0xF0,0x0B,0xF8,0x60,0x3F,0xE8,0x07,0xF0
,0x0E,0x72,0xBE,0x13,0xB9,0xC6,0x11,0xFE
,0x04,0xFE,0xC0,0x2F,0xF4,0x02,0xFE,0x02
,0xFF,0x40,0x3F,0xE0,0x27,0xF0,0x38,0x1F
,0xD8,0x47,0xF0,0x83,0xF8,0x4F,0x90,0x97
,0x78,0x3C,0x0E,0xF8,0x23,0xF9,0x03,0xC8
,0xEF,0x88,0xEF,0x10,0xF2,0x1F,0x71,0x0E
,0xE4,0x70,0x3F,0xD0,0x2F,0xD4,0x03,0x7F
,0x50,0x1F,0xC0,0x2B,0xFD,0x00,0xFF,0x80
,0xEF,0xA0,0x73,0x1F,0x61,0x9D,0xC2,0x17
,0xD0,0x9F,0x20,0x6F,0x70,0x79,0x19,0xE8
,0x8E,0xE3,0x07,0x91,0xBF,0x10,0xDE,0x48
,0xE6,0x3D,0xE2,0x3B,0x98,0x61,0x3E,0xE0
,0x2F,0xD4,0x03,0xFD,0x44,0x37,0x90,0x27
,0xFC,0x80,0x7F,0x80,0x5F,0xC0,0x3C,0xCF
,0x1C,0xC7,0x23,0x0F,0xC8,0x5F,0x88,0x2F
,0xB8,0x1D,0x0E,0xB1,0x8E,0xF1,0x87,0x91
,0xAF,0x88,0xCF,0x28,0xE6,0x3D,0x71,0x1D
,0xD8,0xC2,0x7F,0x44,0x6B,0xA8,0x0B,0xFD
,0x88,0x4F,0xA0,0x5F,0xE8,0x02,0xFE,0x81
,0xEE,0x01,0xE6,0x3D,0xE3,0x1D,0x8C,0x1F
,0x43,0x3E,0x42,0xDE,0xC0,0xF8,0x35,0xE4
,0x36,0xCC,0x1F,0x21,0xBF,0x10,0xDE,0x21
,0xE6,0x35,0xE3,0x1B,0x8C,0x71,0x5E,0x70
,0x8E,0xE6,0x21,0x7E,0x46,0x33,0xC4,0x13
,0xFC,0x60,0x67,0x32,0xAF,0xB4,0x07,0x33
,0xE6,0xB4,0xA4,0x37,0xC4,0xF3,0xA0,0x3F
,0x38,0xC3,0x75,0x60,0x5E,0xD5,0x02,0xFB
,0x08,0xF6,0x28,0x1B,0xF5,0x50,0xCE,0x61
,0x7F,0xA1,0x02,0xFB,0x95,0xD4,0x04,0xF2
,0x3D,0xE4,0x1D,0x4C,0x2F,0x61,0x6E,0x43
,0x7C,0xA0,0xF6,0x15,0xE6,0x2D,0xC4,0xBC
,0x8F,0x39,0x4B,0xA9,0x4E,0x2B,0x9C,0xC6
,0xD3,0x4C,0x27,0xCC,0x4F,0x49,0x60,0xDE
,0xD5,0x88,0xD4,0x8D,0xFB,0x41,0x19,0xD7
,0x3D,0x90,0x1B,0xC4,0xDD,0x98,0x9A,0xB3
,0x39,0x87,0x39,0x1B,0x59,0x87,0x31,0x6E
,0x33,0x66,0x31,0x96,0x73,0x55,0xA8,0x64
,0xE6,0x59,0xCC,0xD2,0x99,0x5C,0x95,0x99
,0x96,0x35,0x52,0xB5,0x13,0xD5,0x55,0x1A
,0xAA,0x52,0xD5,0x74,0xA9,0x95,0x6A,0x93
,0xEA,0xAA,0x26,0xA5,0x69,0x2F,0x53,0x94
,0x6A,0x95,0x69,0x34,0xF5,0xA2,0x55,0x2D
,0x51,0xB6,0xB5,0x85,0x69,0x36,0x95,0xAA
,0xB6,0x45,0xA5,0x56,0x4D,0xAA,0x9A,0x95
,0x54,0x36,0xCA,0xE5,0x6A,0xAA,0xA4,0xAB
,0x4A,0xAD,0x6D,0x2A,0x95,0x54,0xB1,0xF2
,0xAD,0x45,0xD1,0x55,0x4A,0xAB,0x3C,0x96
,0x54,0x74,0x69,0xD2,0xEC,0x8D,0x4B,0xA4
,0x55,0x56,0xD9,0x55,0x54,0xAA,0xAD,0x52
,0xCA,0xCA,0xAA,0xAA,0x55,0x56,0xB5,0x55
,0x2B,0x46,0x55,0x6A,0xAA,0x8C,0xA9,0x55
,0x65,0x65,0xC7,0x8E,0x1C,0x38,0xE1,0xC7
,0x8E,0x3C,0x70,0xE1,0xC7,0x8E,0x1C,0x78
,0xE1,0xC7,0x0E,0x3C,0x70,0xE3,0x87,0x1E
,0x38,0x71,0xE3,0x87,0x1E,0x38,0x71,0xC3
,0x8F,0x1C,0x38,0xE1,0xC7,0x8E,0x1C,0x78
,0xE1,0xC7,0x8E,0x1C,0x78,0xE1,0xC7,0x8E
,0x1C,0x78,0xE1,0xC7,0x0E,0x1C,0x78,0xE1
,0xC7,0x8E,0x1C,0x78,0xE3,0xC7,0x0E,0x38
,0x71,0xE3,0x87,0x1C,0x38,0xF1,0xC3,0x8F
,0x1C,0x38,0xF1,0xC3,0x8E,0x1C,0x78,0xE3
,0xC7,0x0E,0x3C,0x70,0xE3,0x87,0x0E,0x3C
,0x70,0xE3,0x87,0x1E,0x66,0x66,0x66,0x66
,0x4C,0xCC,0xCC,0xCC,0xCC,0xD9,0x99,0x99
,0x99,0x99,0x33,0x33,0x33,0x33,0x32,0x66
,0x66,0x66,0x66,0x66,0x4C,0xCC,0xCC,0xCC
,0xCC,0xCD,0x99,0x99,0x99,0x99,0x99,0x33
,0x33,0x33,0x33,0x33,0x32,0x66,0x66,0x66
,0x66,0x64,0xCC,0xCC,0xCC,0xCC,0xCC,0xD9
,0x99,0x99,0x99,0x33,0x33,0x33,0x32,0x66
,0x66,0x66,0x66,0x64,0xCC,0xCC,0xCC,0xCC
,0x99,0x99,0x99,0x93,0x33,0x33,0x32,0x66
,0x66,0x66,0x64,0xCC,0xCC,0xCC,0xCC,0x99
,0x99,0x99,0x99,0x9B,0x33,0x33,0x33,0x32
,0x66,0x66,0x66,0x64,0xCC,0xCC,0xCC,0x99
,0x99,0x99,0x93,0x33,0x33,0x32,0x66,0x66
,0x66,0x66,0x4C,0xCC,0xCC,0xD9,0x99,0x99
,0x93,0x33,0x33,0x33,0x36,0x66,0x66,0x66
,0x66,0x64,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC
,0xCE,0x66,0x66,0x66,0x63,0x33,0x33,0x19
,0x99,0x99,0x9C,0xCC,0xCC,0xCC,0xE4,0x66
,0x66,0x66,0x67,0x33,0x33,0x33,0x35,0x53
,0x29,0x99,0x94,0xCC,0xD6,0x65,0x55,0x66
,0x66,0x63,0x33,0x33,0x56,0x63,0x33,0x33
,0x35,0x55,0x54,0xAA,0xAA,0xAA,0x99,0x99
,0x33,0x54,0xB3,0x55,0x33,0x66,0x66,0x66
,0xCC,0x65,0x4C,0xD9,0x99,0x95,0x33,0x39
,0xB3,0x33,0x2A,0x66,0x65,0x66,0x4C,0xCC
,0xCC,0xCC,0xD5,0x99,0x99,0x55,0x53,0x2A
,0x66,0x66,0xAA,0xCA,0xAB,0x4A,0xA5,0xA9
,0x99,0x38,0xB3,0x95,0x64,0xBA,0xB1,0xC5
,0x6C,0x34,0xA8,0x8E,0xB3,0x33,0x59,0x73
,0x33,0x36,0x35,0x4A,0x94,0xC9,0xCD,0x54
,0xD5,0xAA,0xAA,0xA9,0xAA,0x95,0x53,0x55
,0x2A,0xAA,0xAA,0xAD,0x55,0x55,0x54,0xAA
,0xCA,0xAA,0x55,0x55,0x55,0xAB,0x4A,0xA9
,0x55,0x55,0x55,0x55,0x4B,0x55,0x56,0x66
,0x55,0x54,0xB5,0x55,0x52,0xAA,0xAA,0xAA
,0xAA,0xAA,0xA5,0x55,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0x9A,0xAA,0xAA,0x55
,0x55,0x4D,0x53,0x55,0x55,0x54,0xB5,0x55
,0x55,0x55,0x52,0x95,0x2D,0x55,0x56,0xAD
,0x55,0x29,0x55,0x55,0x55,0x6A,0xAA,0x95
,0x4A,0xAA,0xAA,0x9A,0xAA,0xA9,0x55,0x5A
,0xAA,0xAB,0x55,0x52,0x95,0x2A,0xCB,0x55
,0x56,0x95,0x4A,0xAA,0xB5,0x55,0x55,0x54
,0xA9,0x56,0xAD,0x55,0x55,0x54,0xA5,0x55
,0x56,0xD5,0x55,0x54,0xA9,0x55,0x56,0xAA
,0xAA,0xAA,0xA9,0x54,0xD2,0xD5,0x54,0xAA
,0xB5,0x55,0x55,0x56,0xAA,0x55,0x55,0x54
,0xAB,0x55,0x54,0xAA,0xAA,0xAA,0xAB,0x55
,0x55,0x25,0x55,0x55,0x55,0x6A,0xCA,0xA9
,0x55,0x55,0x55,0x55,0x55,0x53,0x2A,0xAB
,0x59,0x55,0x72,0x59,0x24,0x96,0x5F,0x03
,0xE0,0xF8,0x3E,0x07,0xC1,0xF0,0x7E,0x0F
,0x83,0xE0,0xF8,0x3E,0x0F,0x83,0xE0,0xF8
,0x3E,0x0F,0x81,0xF0,0x7C,0x1F,0x07,0xC1
,0xF0,0x7C,0x0F,0x83,0xE0,0xF8,0x3E,0x0F
,0x83,0xE0,0xF8,0x3E,0x0F,0x83,0xE0,0xFC
,0x1F,0x07,0xC1,0xF0,0x7C,0x1F,0x03,0xE0
,0xF8,0x3E,0x0F,0x83,0xF0,0x7C,0x1E,0x07
,0xC1,0xF0,0x7C,0x1F,0x07,0xC1,0xF0,0x7C
,0x1F,0x07,0xC0,0xF8,0x3E,0x0F,0x83,0xE0
,0xF8,0x3E,0x0F,0x83,0xE0,0xF8,0x3E,0x0F
,0x83,0xF0,0x7C,0x1F,0x07,0xC1,0xF0,0x7C
,0x1F,0x07,0xC1,0xF8,0x3E,0x0F,0x83,0xE0
,0xF8,0x3E,0x07,0x83,0xE0,0xFC,0x1F,0x07
,0xC1,0xF0,0x7E,0x0F,0x83,0xE0,0xF8,0x3E
,0x0F,0x83,0xF0,0x7C,0x1E,0x07,0xC1,0xF0
,0x7C,0x1F,0x07,0xC1,0xF8,0x3D,0x0C,0xCE
,0x67,0x31,0x98,0xCC,0x67,0x33,0x99,0xCC
,0x66,0x33,0x19,0xCC,0xE6,0x73,0x31,0x98
,0xCC,0x66,0x33,0x99,0xCC,0xE6,0x33,0x19
,0x8C,0xCE,0x63,0x33,0x99,0xCC,0xE6,0x73
,0x19,0x8C,0xC6,0x63,0x31,0x9C,0xCE,0x66
,0x33,0x19,0x8C,0xC6,0x63,0x39,0x9C,0xC6
,0x63,0x31,0x98,0xCE,0x67,0x33,0x99,0xCC
,0x66,0x33,0x31,0x99,0xCC,0x67,0x17,0x19
,0xC8,0xE6,0x3A,0x95,0x8A,0xE4,0x75,0x1B
,0x4B,0x52,0xD2,0x74,0x9D,0x46,0xA9,0xA9
,0x6A,0x57,0x2A,0xB1,0xA9,0x55,0x56,0x53
,0x51,0xAA,0xAC,0x6B,0x33,0x98,0xCC,0xD6
,0x33,0x29,0xAA,0xAC,0x6B,0x2A,0xAA,0xA9
,0x6A,0x9A,0x95,0x55,0x55,0x55,0x2D,0x4A
,0xD4,0xB5,0x54,0xAA,0x95,0xAA,0xB5,0x54
,0xAA,0xAA,0xD4,0xAA,0x95,0x55,0x55,0x6A
,0xAA,0xAA,0xAA,0xCA,0x55,0x2A,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xCA,0xCA,0x69,0x55
,0x55,0x55,0x53,0x55,0x55,0x55,0xA9,0x52
,0xA9,0xAD,0x55,0x52,0xD5,0x54,0xAB,0x55
,0x54,0xAA,0xAA,0xAA,0x95,0x55,0x56,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xA9,0x55,0x55
,0x52,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x95
,0x55,0x56,0xAA,0xAA,0xAA,0xA5,0x55,0x55
,0x55,0x55,0x55,0x52,0xAA,0xAA,0xB5,0x55
,0x55,0x54,0xA6,0xAA,0xAA,0xAA,0xAA,0xAA
,0xA9,0x6A,0xAA,0xD2,0xAA,0xAA,0xAA,0x4A
,0xAA,0xDA,0xAA,0xA9,0x55,0x52,0xAD,0x55
,0x54,0xAA,0xAA,0xAA,0xAB,0x55,0xAA,0x54
,0xAA,0xAA,0xAA,0xD5,0x55,0x4A,0x95,0x56
,0xAA,0xAD,0x55,0x52,0x54,0xAB,0x55,0x55
,0x55,0x6A,0xA5,0x55,0x55,0x52,0xAB,0x55
,0x4A,0xAA,0xAB,0x52,0xAA,0xAA,0xAA,0x95
,0x55,0x55,0x55,0x55,0x55,0x2A,0xAA,0xAC
,0x95,0xA9,0x9A,0xAA,0xAA,0xAA,0xCA,0xA4
,0xAA,0xAD,0x55,0x55,0x5A,0x55,0x2A,0xD5
,0x55,0x2A,0xAA,0xA9,0x55,0x55,0x55,0x55
,0x53,0x33,0x2A,0xAA,0xB5,0x52,0xAD,0x55
,0x55,0x55,0x2A,0xB2,0x95,0x9B,0x34,0xAA
,0xAA,0xAD,0x32,0xAA,0xA9,0x4A,0x6A,0xAD
,0x4D,0x2D,0x6A,0xAA,0x96,0xA5,0x55,0x4A
,0xAA,0xCC,0xD3,0x55,0x55,0x54,0xAD,0x2A
,0xAA,0xAA,0xA9,0x6A,0xAA,0xAA,0xAA,0xAA
,0x55,0x55,0x59,0x55,0x55,0x55,0x34,0xAA
,0xAD,0x29,0xAA,0xAA,0x55,0x56,0xAA,0xA8
,0xAB,0x2A,0xD3,0x55,0x55,0x55,0x4A,0xA9
,0x54,0xB5,0x65,0x5A,0xA9,0x4D,0x6A,0xAA
,0x95,0x55,0xAA,0xAA,0xAD,0x4A,0x55,0x6A
,0xAA,0x55,0x4C,0xCC,0xAA,0xAA,0xD4,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0x6A,0x55,0x6A
,0xAA,0xAA,0xA9,0x56,0xA9,0x53,0x59,0xAA
,0x9A,0x9A,0xAA,0x94,0xCD,0x53,0x2A,0xD5
,0x5A,0x65,0x55,0x55,0x2A,0xAA,0xAC,0xAA
,0xAA,0xAA,0xB5,0x55,0x54,0xAA,0x95,0x52
,0xAA,0xAC,0xB5,0x35,0xA5,0x95,0x56,0x55
,0x2A,0xA5,0x6A,0xAA,0xAB,0x55,0x2A,0x6A
,0xAA,0xA5,0x55,0xAA,0xA9,0x69,0x56,0xAA
,0x55,0x55,0x55,0x2D,0x55,0x55,0x2A,0xAA
,0xAD,0x33,0x32,0xAB,0x4A,0xCA,0xAD,0x55
,0x2A,0xAA,0xB5,0x4A,0xA5,0xAA,0xA9,0x55
,0x55,0x55,0x35,0x6A,0x95,0x55,0x56,0x9A
,0x53,0x2A,0xCA,0xAA,0xAA,0xAA,0x9A,0xAA
,0xB2,0x55,0x52,0xD8,0xCA,0xA9,0xD5,0x52
,0xAC,0x6B,0x54,0xAA,0xAA,0xA9,0x55,0x6A
,0xA9,0x55,0x55,0xA9,0x4A,0xAA,0xAD,0x54
,0xB5,0x33,0x52,0xAA,0xAA,0xA5,0x2D,0x6A
,0xD5,0x55,0x92,0xD4,0xAA,0xAA,0xAA,0x53
,0x55,0x6B,0x52,0xAA,0xAD,0x2A,0xAA,0xAA
,0x95,0x55,0x56,0xAA,0x56,0xAB,0x55,0x4A
,0xA9,0x55,0x32,0xAD,0x55,0x55,0x6A,0xAB
,0x55,0x55,0x25,0x65,0x2A,0xAB,0x55,0x95
,0x55,0x5A,0xA9,0x52,0xAA,0xA5,0x56,0xAD
,0x54,0xAA,0xAB,0x55,0x55,0x55,0x54,0x95
,0x55,0x55,0x4D,0x5A,0xAD,0x2A,0xAA,0xAA
,0xAA,0xA9,0x34,0xA9,0x55,0xB5,0x55,0x4D
,0x2D,0x5A,0x95,0x55,0x4A,0x96,0xAD,0x59
,0x52,0xD5,0x55,0x4D,0x34,0xAA,0xA6,0x35
,0xAB,0x53,0x2A,0x94,0xD4,0xAD,0x55,0x55
,0x1E,0x0F,0x1E,0x38,0x71,0xC7,0x0E,0x1C
,0x3C,0x78,0x78,0x70,0xE1,0xC7,0x1C,0x78
,0xE1,0xC3,0xC7,0x87,0x0F,0x1E,0x38,0x71
,0xC7,0x0E,0x1C,0x3C,0x78,0x70,0xF1,0xE3
,0x87,0x1C,0x70,0xE1,0xC3,0xC7,0x87,0x0F
,0x1E,0x38,0x71,0xC7,0x1C,0x78,0x3C,0x78
,0x70,0xE1,0xE3,0x87,0x8E,0x36,0x1C,0x71
,0xC3,0x87,0x1E,0x38,0x78,0x71,0xE3,0xA3
,0x87,0x0E,0x3C,0x70,0xE7,0x2B,0x25,0x53
,0x8E,0x96,0x55,0x63,0x87,0x1D,0x38,0xE3
,0x8D,0x39,0x62,0xCB,0x2D,0x34,0x72,0x71
,0xC7,0x1A,0xAB,0x4D,0x1C,0x72,0xD2,0xCA
,0xC7,0x1C,0x9C,0x38,0xF4,0x70,0xE3,0x97
,0x2A,0x58,0xE2,0xE1,0xC7,0xA3,0x8C,0x63
,0x9C,0x63,0x1C,0xE7,0x18,0xC7,0x38,0xC6
,0x31,0xCE,0x31,0x8E,0x71,0x8C,0x73,0x8C
,0x63,0x9C,0xC7,0x38,0xC6,0x31,0x8E,0x63
,0x9C,0xE7,0x39,0x8E,0x73,0x98,0xE6,0x39
,0xCE,0x31,0x8C,0xE7,0x31,0x8C,0xC6,0x39
,0x8C,0xE7,0x38,0xCC,0x66,0x73,0x8C,0xE6
,0x31,0x8E,0x67,0x31,0x8C,0x73,0x67,0x18
,0xCC,0x73,0x8C,0x63,0x98,0xC6,0x39,0xC7
,0x18,0xCE,0x35,0x8E,0x63,0x98,0xE6,0x39
,0x8E,0x71,0x99,0xC6,0x99,0xA6,0x58,0xB5
,0x55,0x55,0x56,0x69,0x98,0xE3,0x98,0xCC
,0x71,0xCC,0x67,0x39,0x8E,0x63,0x34,0xCC
,0xAA,0xA5,0x9C,0x66,0x59,0xAC,0xAA,0xAA
,0x65,0x99,0x8C,0xE6,0x73,0x31,0x98,0xCC
,0x66,0x33,0x99,0x8C,0xC6,0x73,0x39,0x98
,0xCE,0x63,0x31,0x98,0xCC,0x67,0x33,0x98
,0xCC,0xE6,0x63,0x39,0x8C,0xCE,0x63,0x39
,0x9C,0xCC,0x67,0x31,0x98,0xCC,0x66,0x73
,0x19,0xCC,0xE6,0x63,0x31,0x9C,0xC6,0x63
,0x31,0x9C,0xC6,0x67,0x31,0x9C,0xC6,0x73
,0x39,0x8C,0xCC,0x73,0x31,0x8C,0xE6,0x63
,0x99,0xCC,0xC6,0x33,0x38,0xCC,0xCE,0x63
,0x35,0x98,0xCC,0xE3,0x31,0xB1,0xCC,0x66
,0x6B,0x19,0x9C,0xE6,0x33,0x31,0xCC,0xCC
,0x66,0x69,0x99,0x99,0x66,0x66,0x31,0xAA
,0xA6,0x63,0x39,0x9C,0xC6,0x73,0x9C,0xC7
,0x19,0xCE,0x31,0x9C,0x63,0x18,0xE6,0x39
,0xCE,0x31,0x8C,0x73,0x9C,0xE3,0x18,0xC7
,0x38,0xC6,0x31,0xCE,0x31,0xCE,0x71,0x8E
,0x71,0x8E,0x71,0x8E,0x31,0xCE,0x31,0xC6
,0x39,0xC7,0x38,0xC7,0x1C,0xE3,0x8C,0x71
,0xCE,0x38,0xC7,0x1C,0x63,0x8E,0x39,0xC7
,0x1C,0x73,0x9C,0x63,0x4E,0x66,0x38,0xCE
,0x38,0xCD,0x39,0x99,0x33,0xA6,0x35,0xA3
,0x1C,0x67,0x4C,0x71,0x8C,0xE9,0x9A,0x71
,0x9A,0x63,0x56,0x6A,0x69,0x94,0xD5,0x4C
,0xE3,0x9C,0xB2,0x9A,0x65,0x95,0x59,0x66
,0xA9,0x63,0x4C,0xE6,0x59,0x63,0x1C,0xA6
,0xAA,0xB5,0x61,0xC7,0x1C,0x71,0xE3,0x8E
,0x3C,0x71,0xC7,0x0E,0x38,0x71,0xC7,0x1E
,0x38,0xE1,0xC7,0x1C,0x38,0xE1,0xC7,0x1C
,0x38,0xE3,0xC7,0x1C,0x71,0xC3,0x8E,0x1C
,0x71,0xE3,0x8E,0x1C,0x70,0xE3,0x8F,0x1C
,0x70,0xE3,0x8F,0x1C,0x70,0xE3,0x8E,0x1C
,0x71,0xC7,0x0E,0x38,0x73,0x63,0x47,0x1C
,0xAC,0x69,0xCD,0x89,0x9A,0xAA,0xC7,0x1A
,0x35,0x66,0x65,0x4E,0x59,0x52,0xAB,0x2D
,0x31,0xB3,0xA7,0x16,0x59,0x65,0xA5,0x4D
,0x59,0x69,0x95,0x96,0x38,0xD3,0x53,0x36
,0x32,0xD5,0x55,0x2A,0x6A,0xA6,0xCB,0x1C
,0x72,0xE3,0x46,0x9A,0x74,0xE4,0xE3,0x8E
,0x38,0xC7,0x1C,0xE3,0x1C,0x73,0x8E,0x31
,0xC6,0x38,0xC7,0x38,0xC7,0x18,0xE7,0x1C
,0xE3,0x18,0xE7,0x18,0xE7,0x18,0xE3,0x1C
,0xE3,0x1C,0xE3,0x1C,0xE7,0x18,0xC7,0x38
,0xC6,0x31,0xCE,0x31,0x8C,0x63,0x9C,0xE7
,0x19,0xC6,0x31,0x9C,0x73,0x1C,0xE6,0x33
,0x38,0xC7,0x38,0xCE,0x39,0x8E,0x33,0x8C
,0xC6,0xA9,0xCC,0xCA,0x99,0xB3,0x33,0x34
,0xB3,0x2A,0x66,0x39,0x96,0x71,0x9C,0x71
,0x8C,0xE3,0x94,0xC6,0x71,0xCE,0x35,0x8E
,0x69,0x96,0x53,0x2A,0x9A,0x66,0x99,0x99
,0x33,0x36,0x59,0x9A,0x98,0xD1,0x9C,0x63
,0x38,0xCE,0x67,0x19,0xCC,0x63,0x39,0xCC
,0x63,0x19,0xCE,0x33,0x98,0xE6,0x31,0x9C
,0xE7,0x19,0x8E,0x73,0x9C,0x67,0x38,0xC6
,0x71,0x8E,0x73,0x9C,0xE3,0x18,0xC7,0x31
,0xCE,0x71,0x8C,0x73,0x8C,0xE3,0x9C,0x63
,0x8C,0x73,0x8C,0x73,0x8C,0x63,0x8C,0x71
,0x8E,0x39,0x96,0x33,0x66,0x9C,0x63,0x4D
,0x5C,0xC7,0x19,0x96,0x55,0x65,0x4E,0x64
,0xCE,0x69,0x8E,0x63,0x98,0xE3,0x19,0xA3
,0x32,0xA6,0xAC,0x73,0x1C,0xCA,0x9C,0xAA
,0xAB,0x2A,0xC7,0x18,0xE6,0x38,0xE6,0x5A
,0x66,0x9A,0x65,0x95,0x59,0xA6,0x99,0x4B
,0x2C,0x71,0xC7,0x1C,0x71,0xC7,0x1C,0x71
,0xC7,0x18,0xE3,0x8E,0x38,0xE3,0x8E,0x31
,0xC7,0x1C,0x71,0xC7,0x1C,0x71,0xC7,0x1C
,0x71,0xC7,0x18,0xE3,0x8E,0x38,0xE3,0x8E
,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0x31,0xC7
,0x1C,0x71,0xCE,0x38,0xE3,0x8E,0x71,0xC7
,0x18,0xE3,0x8E,0x71,0xCE,0x31,0xC6,0x39
,0xC7,0x38,0xE3,0x1C,0x63,0x8C,0xE3,0x8C
,0xD1,0xCD,0x35,0x53,0x2A,0x71,0xA7,0x34
,0x66,0x9C,0x63,0x98,0xE9,0x99,0x99,0x33
,0x1C,0x73,0x96,0x59,0x65,0x55,0x4C,0xD3
,0x8D,0x38,0xC7,0x1A,0x71,0xCE,0x39,0x55
,0x8D,0x34,0xD3,0x4C,0x71,0xC7,0x2C,0xD5
,0x4D,0x2C,0x69,0xA7,0x1C,0x71,0x96,0x34
,0xD3,0x4E,0x34,0xD3,0x19,0x8C,0xE6,0x73
,0x19,0x8C,0xC6,0x73,0x31,0x98,0xCC,0x66
,0x33,0x19,0x8C,0xC6,0x63,0x39,0x98,0xCE
,0x67,0x33,0x39,0x9C,0xCC,0xC6,0x63,0x33
,0x99,0xCC,0xC6,0x67,0x33,0x99,0x8C,0xCE
,0x66,0x33,0x31,0x99,0xCC,0xE6,0x67,0x33
,0x19,0x8C,0xCE,0x66,0x33,0x99,0x8C,0xCE
,0x66,0x33,0x33,0x99,0xCC,0xC6,0x66,0x33
,0x99,0xCC,0xCC,0x67,0x31,0x98,0xCC,0xCE
,0x57,0x2B,0x4A,0xCC,0x66,0x65,0x95,0x94
,0xE4,0xB3,0x2A,0x9A,0xCA,0xE5,0x5A,0x99
,0x8C,0xCC,0x66,0x65,0x99,0x95,0x95,0x66
,0x65,0x39,0x8C,0xCC,0xCC,0xC6,0x66,0x66
,0x33,0x33,0x99,0x98,0xCC,0xCC,0x66,0x63
,0x33,0x33,0x99,0x99,0x98,0xCC,0xCC,0xCC
,0xCC,0xC6,0x66,0x66,0x66,0x66,0x33,0x33
,0x33,0x33,0x33,0x19,0x99,0x99,0x99,0x99
,0x99,0x99,0x99,0x9C,0xCC,0xCC,0xCC,0xCC
,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC
,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x99
,0x99,0x99,0x99,0x99,0x93,0x33,0x33,0x33
,0x32,0x66,0x66,0x66,0x66,0x6C,0xCC,0xCC
,0xCC,0x99,0x99,0x99,0x99,0x93,0x33,0x33
,0x33,0x33,0x32,0x66,0x66,0x66,0x4C,0xCC
,0xCC,0xCC,0xD9,0x99,0x99,0x99,0x33,0x33
,0x33,0x33,0x66,0x66,0x66,0x66,0x66,0xCC
,0xCC,0xCC,0xCC,0xC9,0x99,0x99,0x99,0x99
,0xB3,0x33,0x33,0x33,0x32,0x66,0x66,0x66
,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66
,0x73,0x33,0x33,0x33,0x31,0x99,0x99,0x8C
,0xCC,0xE6,0x66,0x33,0x33,0x99,0x98,0xCC
,0xC6,0x66,0x73,0x33,0x19,0x98,0xCC,0xC6
,0x73,0x19,0xCC,0xE6,0x63,0x31,0x98,0xCC
,0xC7,0x31,0x9C,0xC6,0x63,0x19,0xCC,0xE7
,0x31,0x99,0x8E,0x31,0x9C,0x67,0x39,0x8C
,0xE3,0x38,0xCC,0x73,0x9C,0xC6,0x38,0xCE
,0x33,0x98,0xE3,0x38,0xCE,0x31,0x8E,0x63
,0x98,0xE7,0x18,0xC6,0x39,0x8E,0x73,0x8C
,0x63,0x9C,0xE3,0x18,0xC7,0x39,0xC6,0x39
,0xC6,0x39,0xCE,0x31,0x8E,0x73,0x8C,0x63
,0x9C,0x63,0x9C,0x63,0x9C,0x63,0x1C,0xE3
,0x1C,0x63,0x9C,0x73,0x1C,0x63,0x18,0xE3
,0x38,0xCE,0x33,0x8C,0xD3,0x39,0x56,0x33
,0x8A,0xB1,0x99,0x59,0x4E,0x65,0xC6,0x71
,0x96,0x33,0x8C,0xE3,0x59,0x66,0x55,0x53
,0x2A,0xAA,0x5A,0xAC,0xD3,0x54,0xD2,0xAA
,0x6A,0x6A,0xCD,0x35,0x56,0x32,0xC6,0x63
,0x4C,0xE3,0x99,0xA5,0x58,0xD3,0x34,0xD6
,0x59,0x55,0x2A,0xA5,0x59,0x6A,0xB5,0x56
,0x55,0x4A,0x55,0x2A,0xAA,0xAA,0xAA,0xAA
,0xAA,0x65,0x55,0x55,0x55,0x65,0x99,0xA6
,0x99,0x55,0x34,0xCD,0x55,0x55,0x55,0x33
,0x4A,0xAA,0xAC,0xB5,0x1F,0x03,0xC1,0xE1
,0xF0,0xF0,0xF8,0x3E,0x0F,0x83,0xE0,0xF0
,0x78,0x78,0x78,0x3E,0x0F,0x83,0xE0,0xF8
,0x78,0x3C,0x3C,0x3C,0x1F,0x07,0xE0,0xF8
,0x7C,0x3E,0x1C,0x3C,0x3E,0x0F,0x81,0xF0
,0x7C,0x3E,0x1E,0x1C,0x7C,0x3E,0x15,0xE0
,0x78,0x3C,0x1E,0x1E,0x3C,0x3E,0x0F,0x0B
,0x64,0x7C,0x1F,0x0F,0x0D,0x2C,0x3D,0x1D
,0x2C,0xBC,0x3E,0x1D,0x0D,0x54,0xAE,0x1F
,0x0F,0x0F,0x0F,0x0F,0x07,0xC1,0xE8,0xDA
,0x2E,0x8B,0x87,0x47,0x27,0x4A,0xE8,0xB8
,0x5E,0x0F,0x07,0x87,0x87,0x86,0xE2,0xD4
,0x5D,0x17,0x0B,0x8B,0xA3,0xC3,0xD0,0xF0
,0xB6,0x2E,0x95,0xC5,0xC5,0xA2,0xD1,0xB1
,0x6A,0xAA,0xAA,0xD1,0xD1,0xD1,0xD1,0xB2
,0xB2,0x69,0x55,0x55,0x55,0x55,0x65,0x69
,0x69,0x59,0x54,0xB5,0x35,0x55,0x55,0x65
,0x69,0x69,0x6A,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x2D,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0xCC,0x79,0x84,0xE2,0x98,0x9E,0x71
,0x5A,0x55,0x6A,0xA5,0x6D,0x68,0xC7,0x18
,0xF6,0x04,0xF4,0x1F,0xD5,0xE1,0x9E,0x60
,0xDE,0x01,0xF8,0x1F,0xD7,0x62,0x3C,0xC3
,0xB8,0x17,0xA2,0x76,0x99,0x55,0x4C,0xD1
,0x96,0xD1,0x9E,0x22,0x45,0x39,0xC6,0x7C
,0xC7,0xE8,0x0F,0xC0,0x24,0x99,0xC2,0x3E
,0x43,0xFC,0x0F,0xC0,0x95,0x2E,0x65,0x9A
,0x66,0x69,0xAC,0x4E,0xCD,0xD4,0x63,0x98
,0x33,0x81,0x67,0x05,0xFE,0xBB,0x0C,0x7B
,0x07,0x78,0x05,0xC1,0x9F,0xB6,0x6C,0x47
,0x98,0x36,0xA6,0xAC,0xAA,0x54,0xA5,0x99
,0xC3,0x3E,0x43,0xF6,0xDB,0x18,0x60,0x88
,0xEE,0x13,0xF2,0x1F,0xC7,0xD4,0xC2,0x44
,0x4B,0xB8,0x4F,0x88,0xFA,0x9B,0x26,0xAA
,0xB5,0xAA,0x63,0x98,0x73,0x82,0x32,0x4E
,0x77,0xB7,0x6E,0x18,0xE6,0x0C,0xE0,0x2C
,0x27,0x9B,0xEB,0x5B,0xA3,0x1C,0xC3,0xD4
,0x33,0x53,0x55,0x52,0x55,0x24,0x73,0x8C
,0xF0,0x9F,0xB1,0xF4,0x1F,0x00,0x9E,0x04
,0xE7,0x19,0xF1,0x1F,0xA3,0xEC,0x1F,0x02
,0xA6,0x15,0x73,0x8C,0xE3,0x2A,0xAC,0x93
,0xC4,0xF5,0x2B,0xED,0x63,0x1C,0xC1,0xDC
,0x07,0x81,0x7E,0x1F,0xC1,0xFB,0xB4,0x63
,0x98,0x3B,0x84,0xF0,0x4F,0x0B,0xAA,0x67
,0x16,0x55,0x8C,0xD8,0x9F,0x50,0xFD,0x0F
,0x80,0xBA,0x08,0x97,0x38,0xCF,0x88,0xFE
,0x0F,0xE0,0x7C,0x0F,0x02,0x92,0xE6,0x39
,0xD3,0x1D,0x4A,0xD5,0x52,0xB5,0x4B,0xAD
,0xA3,0x1C,0xC1,0xDC,0x07,0xC0,0xBE,0x0F
,0xE1,0x3F,0xB4,0x63,0x98,0x33,0x82,0x70
,0x5F,0x83,0xE9,0x8E,0xAC,0x71,0xAA,0xAC
,0xB5,0x47,0xD1,0x1E,0x82,0xA8,0x4B,0x9C
,0x47,0xEC,0x3F,0x4F,0xB2,0x1D,0x81,0x22
,0x2E,0xE3,0x1F,0xA1,0x3D,0x9B,0x91,0x5A
,0x54,0xAA,0xB2,0xAC,0xA2,0xDC,0x24,0xA6
,0xE2,0x9F,0xB6,0xC3,0x39,0xCC,0x33,0xCC
,0x06,0xF8,0x0E,0xFD,0x71,0x8C,0x77,0x12
,0xDC,0x24,0xBA,0xA4,0xD9,0x65,0x39,0x86
,0x73,0x98,0xC7,0xEA,0x13,0x8C,0x12,0x63
,0xB9,0xCE,0x73,0x39,0xCC,0x73,0x19,0xC6
,0x4C,0xA6,0x5A,0xD5,0x6A,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAB,0x2A,0xAA
,0xAA,0xAC,0xD3,0x34,0xCA,0xE3,0x2D,0x53
,0x55,0x53,0x34,0xD5,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x54,0xCD,0x55,0x55,0x55,0x53,0x4C
,0xD3,0x35,0x55,0x35,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x54,0xD5,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x4D,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x58
,0x79,0x65,0xC4,0xCD,0x74,0xB9,0x73,0x25
,0x46,0xB5,0x54,0x59,0x54,0xAA,0xDB,0x54
,0xAC,0xAB,0x6A,0xA9,0x95,0x55,0x55,0x55
,0x55,0x52,0xCD,0x55,0x58,0x9D,0x15,0xAA
,0xAA,0x63,0xB5,0x75,0x55,0x14,0xE4,0xD5
,0x6A,0x75,0x2A,0x5B,0x36,0xAB,0x4D,0x4A
,0xA9,0x5A,0xCA,0xAA,0x6A,0x56,0xA4,0xA5
,0x6A,0x4B,0x54,0xAB,0x55,0x2A,0xAE,0xAC
,0xAA,0xAA,0xB5,0x56,0xAB,0x4D,0xAA,0xAD
,0x55,0x55,0x8D,0x6A,0x5A,0x94,0xD2,0xC6
,0xCA,0xAA,0xB5,0xA5,0x65,0x5B,0x65,0x51
,0x4C,0x55,0x55,0x42,0xAD,0x4D,0x39,0x4B
,0x71,0x55,0x75,0x15,0x55,0x55,0x65,0x4D
,0x55,0x4D,0x55,0x4D,0x19,0xA9,0x68,0xBA
,0xB4,0xB5,0x56,0xD5,0xA5,0x55,0x2A,0xB8
,0xA6,0xB1,0x32,0xCA,0xEA,0xA5,0x55,0xA9
,0x55,0x52,0xB5,0x53,0x4A,0xAA,0xD4,0xCA
,0x65,0x4D,0x66,0xA9,0xB5,0x4A,0x55,0x4A
,0xD9,0x96,0xAD,0x6C,0x9C,0x55,0x2A,0xA9
,0x39,0x52,0x71,0xCA,0x9D,0x34,0xAA,0xD5
,0x4D,0x59,0x55,0x55,0x4E,0xA2,0x95,0x2B
,0xB5,0x55,0x56,0x9A,0xB0,0xAA,0xDA,0x77
,0x35,0x49,0x45,0x55,0x2A,0xAA,0xB3,0x6A
,0x5A,0x56,0x55,0x55,0x56,0x55,0x6A,0xA9
,0xAA,0xAA,0xAB,0x54,0xB5,0x2A,0xB3,0x55
,0x54,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAD,0x4E,0x59,0x55,0xB5,0x75,0x79,0x89
,0x61,0xB4,0x39,0xB0,0x24,0x92,0xB7,0x6A
,0xAA,0x55,0x55,0x52,0xAB,0x14,0x93,0xEE
,0xB0,0x23,0xFD,0x00,0x93,0xFD,0xD0,0x0F
,0xF6,0x01,0x73,0xF7,0x60,0x17,0xF4,0x05
,0x71,0xF5,0xA1,0x96,0xAA,0xAA,0x97,0x51
,0x4B,0xD3,0x07,0xED,0x83,0xF4,0x04,0xFE
,0x01,0xFF,0x4F,0xB7,0x40,0x37,0xE0,0x1F
,0xE0,0x7E,0xCC,0x09,0xBB,0x09,0x74,0x56
,0xA9,0x55,0xAA,0x29,0xDB,0x07,0xD8,0x1E
,0xC1,0xFD,0x01,0x7E,0x03,0xF8,0x0F,0xA0
,0x7F,0x40,0x9F,0x01,0x7C,0x07,0xE0,0x3F
,0x49,0x1B,0xA9,0x5B,0x2A,0xA7,0x64,0x92
,0x7A,0x23,0xEB,0x03,0xF4,0x1F,0xB0,0x05
,0xFC,0x83,0xEC,0x0F,0xE0,0x7F,0x40,0x49
,0xF1,0x0F,0xC8,0x5E,0xA1,0xEA,0x53,0x65
,0x4E,0x58,0x57,0xD0,0x5F,0x81,0x3E,0xEE
,0x81,0xFC,0x0B,0xF8,0x25,0xC0,0xC3,0xDF
,0x60,0x7F,0x03,0xFA,0x07,0x31,0x31,0x76
,0xAA,0x55,0x55,0x52,0xBB,0x1D,0xB0,0xF8
,0x11,0x2F,0xC0,0x7E,0x03,0xF8,0xED,0xC3
,0xE0,0x11,0x7E,0x21,0xF0,0x27,0xC3,0xE6
,0x3D,0x21,0x54,0xE8,0xAD,0x55,0x52,0xE2
,0xA7,0x82,0xFB,0x6C,0x0E,0xF0,0x7D,0xC1
,0xE0,0x5F,0x01,0xFE,0xEC,0x1D,0xE0,0xF9
,0x83,0xC1,0x9E,0x0B,0xDB,0x50,0xB9,0x95
,0x54,0xD4,0xB5,0x43,0xD8,0x25,0x23,0xE0
,0x5F,0x02,0x7C,0x3E,0x31,0xFA,0x01,0x27
,0xE2,0x1F,0x06,0x7C,0x3E,0x21,0xF4,0xC2
,0x55,0xD2,0x5B,0x2A,0xAA,0xC4,0xC7,0x0A
,0xDD,0xB6,0x0F,0x70,0x3E,0x41,0xF0,0x77
,0x81,0xCE,0x7E,0x03,0xF8,0x1F,0xA0,0x78
,0x33,0xC1,0x6E,0xB5,0x15,0xAA,0x5A,0x96
,0x96,0xC6,0x3E,0x4C,0x61,0x1F,0x80,0xFC
,0x13,0xE1,0xF3,0x07,0xE4,0x10,0x9F,0x88
,0x7C,0x1B,0xF0,0xF1,0x07,0xE3,0x29,0x2E
,0xA4,0xD5,0x55,0x53,0x8B,0x3C,0x0F,0x3B
,0xB0,0x1F,0xC0,0xFB,0x03,0xC1,0xFE,0x03
,0xA3,0xFB,0x07,0xE8,0x3E,0x41,0xF0,0x67
,0x85,0xAC,0xEA,0x2B,0x54,0xD2,0xB5,0x87
,0x88,0xBF,0x0D,0xC0,0x5F,0x80,0xFC,0x1F
,0xC1,0xF1,0x8F,0xCA,0x04,0x4F,0x81,0x7C
,0x1B,0xE0,0xFC,0x0F,0xA3,0x99,0x1B,0x61
,0xB2,0xD4,0xAD,0x85,0xDC,0x0E,0xAB,0xDC
,0x2F,0xA0,0x7C,0x87,0xE0,0x7F,0x03,0xC0
,0xFF,0x05,0xF8,0x1F,0x80,0xF8,0x3B,0x85
,0x5A,0xB3,0x4A,0xAA,0xA5,0x6D,0x13,0xE0
,0x5F,0x87,0xA0,0x4F,0x40,0xFC,0x0F,0xE0
,0xFC,0x87,0xE0,0xC0,0x9F,0x40,0xFC,0x0D
,0xE0,0x7E,0x0F,0xA4,0xD4,0xAB,0x56,0x92
,0xDA,0x87,0xC1,0x5E,0x05,0xFB,0xB4,0x0E
,0xE0,0xFF,0x01,0xC0,0x9F,0x01,0xFE,0xDC
,0x0D,0xF0,0x7E,0xC1,0xC6,0x2E,0x1C,0xD5
,0xA5,0x55,0x55,0x29,0xEA,0xC3,0xE1,0xC7
,0x02,0x7F,0x20,0x7F,0x60,0x1F,0xF4,0x03
,0xF8,0x04,0xBF,0x81,0x65,0xBC,0xED,0x59
,0x6A,0x93,0x4A,0xAA,0xAA,0xAA,0x55,0x55
,0x35,0x55,0x55,0x6B,0xB6,0xAD,0x24,0x8A
,0x29,0x69,0x65,0x69,0x6B,0xB6,0xD9,0xA3
,0x42,0x95,0x4B,0x2A,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xD5,0x65,0x55,0x55,0x4C
,0x94,0x4A,0x55,0x75,0xE6,0xD5,0x95,0x4D
,0x55,0x48,0xA4,0xA5,0x5A,0xD5,0x6B,0x4A
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x95,0x2A
,0x52,0xD2,0xAA,0xAD,0xBB,0x6B,0x49,0x09
,0x49,0x29,0xA9,0x56,0xDD,0xB6,0xAA,0x92
,0x52,0x94,0xCA,0xAA,0xAD,0x55,0x55,0x55
,0x6B,0x55,0xAA,0xD2,0xA1,0x12,0x4A,0xAF
,0xBB,0x6D,0xB6,0xAA,0x04,0x44,0x92,0xEF
,0xB6,0xDB,0x6A,0xA2,0x24,0xAF,0x55,0x25
,0xAA,0xAA,0xA9,0xAD,0x53,0x0C,0xFB,0x30
,0x7E,0x80,0xBF,0xBA,0x30,0xCF,0xC8,0x23
,0xF0,0x09,0xFE,0xD8,0xC4,0x3F,0x60,0x5B
,0x84,0x9D,0xAA,0xA6,0x56,0x52,0xEA,0x98
,0xFA,0xC0,0x49,0x31,0xDE,0x03,0xDF,0x23
,0xFA,0xC0,0x22,0x73,0xBC,0x41,0xBF,0x46
,0xDD,0x10,0x51,0xA7,0x38,0xA6,0xAD,0x4D
,0x2A,0x6B,0xB5,0x18,0x8F,0x79,0x02,0x73
,0x02,0x5F,0xDD,0xB1,0x86,0x7E,0x01,0x66
,0x04,0x9F,0xED,0xA1,0x1E,0xE6,0x0A,0xEC
,0x45,0x9A,0xB2,0xAA,0xD3,0x13,0xDA,0xB3
,0x3D,0x80,0x89,0x9D,0xE6,0x05,0xFD,0xA3
,0x7D,0x80,0x25,0x19,0xE6,0x07,0xFB,0x46
,0x7A,0x91,0x49,0xBA,0x4C,0xAA,0x9A,0x33
,0x49,0x4E,0xF5,0x4C,0x27,0xDC,0x02,0x73
,0x02,0xBF,0xDB,0x18,0x27,0xF8,0x02,0x66
,0x13,0x3F,0x6B,0x30,0x4F,0xB2,0x29,0xCC
,0xAA,0xAA,0x95,0x9D,0x61,0x3B,0xD6,0x67
,0x3B,0x01,0x27,0x7D,0x80,0x77,0xF4,0xC6
,0x74,0x04,0x9C,0xFC,0x02,0xDF,0xAB,0x0C
,0xE4,0x55,0x59,0xAA,0x6A,0xA9,0x29,0xC6
,0x6B,0xAE,0x98,0x27,0xF5,0x80,0x93,0xCC
,0x7F,0x6E,0x20,0x2F,0x73,0x01,0x27,0x3E
,0xED,0xA9,0x82,0x9D,0xB3,0x15,0x4B,0x2A
,0x55,0x4A,0xDD,0x4C,0xCC,0x76,0xD6,0xCC
,0xA4,0x12,0x49,0xBF,0x6D,0xB6,0xD3,0x32
,0xA1,0x12,0x49,0xB7,0x6D,0x5A,0xA6,0x55
,0x55,0x52,0xAA,0xAA,0x92,0xA9,0x55,0x52
,0xAA,0xEE,0xDB,0x52,0x09,0x22,0x95,0x54
,0x55,0xBE,0xED,0xA9,0x04,0x4A,0x55,0x55
,0x2A,0xB6,0xD5,0x55,0x2A,0xAA,0xAA,0xAA
,0xAA,0x92,0x49,0x4D,0xEE,0xDB,0x55,0xAB
,0x32,0x04,0x48,0xAF,0xEE,0xDA,0xD7,0x6D
,0x40,0x49,0x37,0xCC,0x9C,0x76,0xAA,0x55
,0x55,0x52,0xAC,0x70,0xC6,0x31,0x63,0xFB
,0x61,0x4F,0x18,0x33,0x04,0x73,0xDF,0x58
,0xDB,0xC4,0x66,0xC0,0xB9,0xD7,0xA3,0x1E
,0x61,0x9C,0x99,0x55,0x55,0x19,0xCC,0x49
,0xF3,0x3C,0x76,0x4C,0x60,0x5C,0xE0,0xCF
,0x11,0xF3,0xBA,0x63,0x02,0x73,0x07,0x78
,0x67,0x4E,0xA8,0xDC,0x45,0xAC,0x65,0xA6
,0x71,0xA2,0x79,0x0F,0xB6,0x19,0xE1,0x1F
,0x11,0xE0,0x5F,0x03,0xFD,0x8C,0x7C,0x47
,0x84,0x70,0x4F,0x07,0xEB,0x51,0x9D,0x15
,0xC5,0x54,0xD6,0x3A,0x91,0x53,0x9C,0x3D
,0x85,0xF8,0x7E,0x07,0xC0,0x44,0x73,0x83
,0xB8,0x7F,0x0F,0xA0,0xFC,0x04,0x57,0x30
,0xF3,0x1E,0xB1,0xD8,0xAD,0x2A,0xD6,0x31
,0xE1,0x9C,0x15,0xC1,0x7C,0x0F,0xCF,0x63
,0x3E,0x33,0xC0,0x7C,0x0F,0x81,0xF9,0xF4
,0x47,0xC6,0x70,0x5E,0x0B,0xD1,0x5A,0xAA
,0xAA,0x96,0x71,0xD5,0x1E,0x83,0xF0,0x30
,0x9C,0xC0,0xEE,0x1F,0xC3,0xE8,0x3F,0x02
,0x13,0x98,0x3D,0xC3,0xE8,0x7D,0x07,0xC0
,0xC9,0xE3,0x16,0x6A,0x55,0x53,0x2C,0x36
,0xED,0xD1,0x9F,0x08,0xF0,0x2E,0x05,0xE0
,0x7F,0xDB,0x19,0xF1,0x1F,0x01,0xC4,0x7C
,0x0F,0xB5,0xA3,0x3A,0x53,0xA3,0x56,0x55
,0x35,0x89,0x29,0xCC,0x2E,0xC1,0xFC,0x3F
,0x43,0xF0,0x05,0x1E,0xE0,0xEE,0x0F,0xE1
,0xFA,0x1F,0x80,0x8A,0x77,0x0E,0x70,0xBA
,0x9A,0xA6,0xA5,0xAB,0x5A,0x66,0xC6,0x3D
,0x81,0xC8,0x6E,0x0A,0xFE,0xD8,0xCD,0xC8
,0x7B,0x03,0xC0,0xDC,0x17,0xED,0xB1,0x9B
,0x18,0xF4,0x2B,0x4A,0xAA,0xAA,0x55,0x26
,0x66,0x67,0x09,0xF5,0x37,0x63,0x5A,0x41
,0x27,0x72,0x37,0x80,0xFE,0x1F,0x61,0xBA
,0x21,0x27,0x32,0x37,0x88,0xF5,0x32,0xD5
,0x53,0x35,0x74,0xC6,0xCC,0x4F,0x81,0x72
,0x0B,0x71,0x6F,0xD8,0x46,0xEC,0x0B,0xC0
,0x73,0x0A,0x73,0x9F,0x5C,0x46,0xE8,0x4B
,0xD0,0xAB,0x55,0x55,0x54,0xA7,0x33,0x23
,0xF0,0x2F,0xD8,0x4F,0xD8,0x20,0x96,0x66
,0x46,0xF8,0x0F,0xF0,0x8F,0xD0,0x14,0x59
,0xD9,0x1B,0xC4,0x6D,0xA6,0x5A,0x96,0xAB
,0x19,0x9B,0x10,0xEF,0x40,0x9F,0x90,0x7F
,0xB4,0xC4,0xDC,0xC0,0xFE,0x01,0x7F,0x01
,0xFD,0xCC,0x4D,0xCC,0x13,0xEC,0x17,0x58
,0xAA,0xAA,0xAB,0x2A,0x76,0xC1,0x7D,0x44
,0x6F,0x01,0x66,0x6C,0x4F,0xDA,0x06,0xFD
,0x01,0xE4,0x1C,0xCD,0x98,0x9F,0xA0,0xBD
,0x8C,0x70,0xAC,0xE9,0x55,0x4A,0xAB,0x31
,0x36,0xE6,0x3E,0x62,0x66,0xEC,0x04,0xCE
,0xC2,0x9B,0xF6,0x66,0x4C,0xCC,0x09,0x5C
,0xC4,0x5D,0xD7,0x33,0x26,0x6E,0x25,0x66
,0x55,0x6A,0x49,0x99,0xB3,0x23,0x7D,0xB2
,0x0B,0xF6,0x01,0x89,0xFB,0x20,0x7F,0xD2
,0x03,0xFD,0x02,0x27,0x6C,0xC2,0x7D,0xA8
,0x93,0x6B,0x15,0x65,0x56,0x6B,0x22,0x55
,0xEC,0x47,0xEC,0xCC,0x99,0xBC,0x80,0xB3
,0xF6,0x4F,0x99,0x92,0x26,0x76,0x04,0xCF
,0x64,0xDC,0xCC,0xC9,0x9A,0xAC,0xAA,0xCA
,0x56,0x86,0x66,0xDD,0x18,0x9F,0xB3,0x33
,0x10,0x62,0x66,0xCC,0xC4,0xFE,0xB9,0x02
,0x91,0xCC,0xDB,0x33,0x33,0x6D,0x4C,0x6A
,0xA9,0xAA,0xA6,0x5A,0xC4,0xA4,0xD9,0xDD
,0x6C,0xCC,0x99,0x99,0x90,0x93,0x77,0x77
,0x76,0x64,0xCC,0xEC,0x11,0x99,0xDA,0xEC
,0xCC,0x99,0x56,0x94,0xD5,0x54,0xA8,0xD1
,0x73,0x66,0x62,0x6F,0x6E,0x88,0x84,0x66
,0x66,0xCC,0xCC,0xDE,0xD9,0x90,0x46,0x66
,0x6E,0xCC,0xCA,0xED,0x54,0x95,0x55,0x55
,0x54,0xCC,0xCA,0x4C,0xCD,0xDD,0x76,0x64
,0x46,0x6C,0x94,0x48,0xDD,0xEE,0xCC,0x89
,0x99,0x9A,0x89,0x33,0x76,0xD9,0x99,0x19
,0x9B,0x2A,0xAA,0xAA,0xA9,0x4A,0x9B,0x99
,0x9B,0x39,0xB3,0x31,0x0C,0x4C,0xDD,0xCC
,0xD9,0xD9,0x99,0x88,0x48,0xCC,0xEC,0xDC
,0xD5,0x9A,0x99,0x54,0xAA,0xAA,0xAA,0xAA
,0x55,0x55,0x55,0x55,0xAD,0xB5,0xAA,0xA4
,0x45,0x2A,0x55,0x66,0x66,0xCE,0xCD,0x6A
,0xA9,0x4A,0x94,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0x55,0x56,0x94,0xAA
,0x95,0x5B,0x55,0x56,0x95,0x55,0x4D,0x2A
,0xAA,0x95,0x55,0x54,0xB4,0xB5,0x35,0x32
,0xAA,0xAA,0xD2,0xAA,0xAA,0xB4,0xD2,0xD2
,0xAE,0x97,0x48,0xAC,0xAE,0x96,0x55,0x36
,0xA6,0x2A,0xA9,0x6D,0x5A,0xA9,0x64,0xE9
,0xA9,0x56,0xA6,0xAA,0xCD,0x4C,0xAC,0xAA
,0xA9,0x57,0x2D,0x5A,0x8C,0x56,0x55,0x56
,0x2A,0xAD,0x16,0xB5,0x55,0x55,0x52,0xB9
,0x69,0x55,0x8D,0x55,0x4A,0xB5,0x59,0xA5
,0xAA,0xB4,0xAA,0x6A,0xAA,0xA1,0x45,0x75
,0x55,0x55,0x55,0x55,0x52,0xAA,0x54,0x49
,0x54,0xD2,0x65,0x55,0x35,0x55,0x66,0x4C
,0xD3,0x35,0x69,0x94,0xA6,0xAD,0x4A,0xA5
,0x55,0x4A,0xAA,0xAA,0x8D,0xAD,0x55,0x2A
,0xB5,0x4D,0x4A,0xB5,0x54,0xD5,0x52,0xD6
,0x2B,0x54,0xAC,0xA6,0x55,0x2A,0x96,0xA9
,0x2A,0x9A,0xAA,0xA5,0x5A,0x9D,0xAB,0x55
,0x54,0xAD,0x69,0x26,0xA5,0x56,0xAA,0xB2
,0x95,0x66,0x56,0x55,0x55,0x55,0x55,0x54
,0xCD,0x55,0x69,0x6A,0x65,0x5A,0x52,0xAA
,0xAA,0xAB,0x32,0xAA,0xD2,0xAB,0x15,0xA6
,0xA6,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x52,0xD5
,0x55,0x55,0x2A,0xAA,0xAA,0xD5,0x56,0xAA
,0xAA,0xAA,0x55,0x6A,0x56,0xD4,0x56,0xA0
,0xAF,0x20,0xFE,0x43,0xF4,0x07,0xD0,0x5E
,0xC2,0xDD,0x16,0xE4,0xBB,0x03,0xE8,0x1F
,0xA0,0x7E,0x07,0xD0,0xBD,0x16,0xD1,0x75
,0x0B,0xC1,0x7A,0x17,0x82,0xE8,0x5E,0x85
,0xF1,0x3E,0x0B,0xC1,0x78,0x1F,0x83,0xF0
,0xF4,0x2F,0x42,0xE8,0xB4,0x4F,0x07,0xD0
,0xEA,0x1D,0x47,0x43,0xB0,0xDC,0x2F,0x17
,0x89,0xF0,0x6C,0xCD,0x0B,0x64,0xD5,0x5A
,0xAD,0x4A,0xAA,0xA5,0x4A,0xAA,0xAA,0xB4
,0xAC,0x8B,0x29,0x65,0xAD,0xA6,0x96,0xC3
,0x4B,0x55,0x96,0xC7,0x92,0x96,0x8B,0x4F
,0x17,0x2B,0x16,0x1D,0x2C,0x5C,0x5A,0x69
,0x71,0x69,0xC5,0xC3,0x8B,0x8E,0x9E,0x1C
,0x78,0x71,0x71,0xD1,0xC7,0x4E,0x9D,0x34
,0xB2,0xA3,0x8B,0x1C,0x38,0xF0,0xE3,0x87
,0x1C,0x71,0xC5,0x8E,0x1C,0x78,0xE3,0x8E
,0x38,0xE3,0x8F,0x1C,0x71,0xC7,0x1C,0x71
,0xC3,0x8E,0x31,0xC7,0x1C,0x71,0xC7,0x18
,0xE3,0x8E,0x31,0xC7,0x1C,0xE3,0x8E,0x38
,0xC7,0x18,0xE3,0x9C,0x63,0x8E,0x71,0x8E
,0x39,0x96,0x39,0xC7,0x38,0xE3,0x38,0xC7
,0x32,0xC7,0x34,0xE7,0x31,0xC6,0x71,0xC6
,0x31,0xC6,0x71,0x9C,0x65,0x8C,0x66,0xB4
,0xCE,0x31,0xC6,0x39,0x8E,0x65,0x9C,0x63
,0x9C,0x6B,0x39,0x66,0x35,0x56,0x53,0x8C
,0xD5,0x54,0xD5,0x56,0x65,0x4C,0x65,0x4C
,0xAA,0xAA,0xAA,0xAA,0xB5,0x55,0x52,0xAA
,0xAD,0x5A,0xCD,0x55,0x52,0xAA,0x6A,0xAA
,0xCA,0xB2,0x99,0x66,0x35,0x56,0x65,0x39
,0x4C,0xD3,0x1C,0xC7,0x31,0x9C,0x67,0x19
,0xCC,0x73,0x18,0xE6,0x71,0x9C,0xC7,0x31
,0x8C,0xE7,0x39,0xCE,0x63,0x18,0xC6,0x33
,0x8C,0xE7,0x19,0xCC,0x63,0x19,0xCE,0x73
,0x9C,0xE7,0x31,0x8C,0x63,0x19,0xC6,0x73
,0x9C,0x67,0x31,0xCC,0x63,0x18,0xC6,0x33
,0x8C,0xE3,0x39,0xCE,0x73,0x1C,0xC6,0x39
,0x8E,0x63,0x18,0xC6,0x71,0x8C,0xE3,0x18
,0xE6,0x39,0xCC,0x71,0x8C,0x73,0x9C,0x63
,0x1C,0xE3,0x18,0xE7,0x1C,0xE3,0x1C,0xE3
,0x9C,0x71,0x8E,0x71,0xC7,0x38,0xE3,0x1C
,0x71,0xCE,0x31,0x8E,0x71,0x8C,0x73,0x9C
,0x63,0x9C,0xE3,0x1C,0xE3,0x18,0xE7,0x1C
,0xE3,0x9C,0x71,0x8E,0x71,0xC7,0x18,0xE3
,0x8C,0x71,0xC6,0x38,0xE3,0x8E,0x38,0xE3
,0x8E,0x38,0xE3,0x8E,0x38,0xE3,0xC7,0x1C
,0x70,0xE3,0x8E,0x3C,0x71,0xC7,0x0E,0x38
,0xE3,0x87,0x1C,0x78,0xE3,0x8E,0x3C,0x70
,0xE3,0xC7,0x0E,0x38,0xF1,0xE3,0xC7,0x0E
,0x1E,0x38,0xF1,0xC3,0x87,0x1C,0x3C,0x70
,0xF1,0xC3,0x87,0x47,0x0F,0x1C,0x5C,0x38
,0xF1,0xF1,0xE1,0xC7,0x87,0x0F,0x0F,0x1C
,0x3C,0x74,0x72,0x9C,0x38,0x70,0xE3,0xA3
,0xC3,0x8B,0x8E,0x1E,0x1E,0x1E,0x3C,0x5C
,0x78,0x78,0x71,0xA9,0x62,0xD2,0xE1,0xC5
,0xCB,0x53,0x53,0x8B,0x2A,0x96,0x59,0x6A
,0xAA,0xC6,0x96,0xA6,0xAA,0x5A,0x6A,0xAA
,0xA9,0xA5,0x95,0x55,0x55,0x55,0x56,0xAA
,0xAA,0xAA,0x55,0x54,0xD5,0x55,0x4A,0xAA
,0xAA,0xAA,0xA5,0x54,0xD5,0xAB,0x56,0xAC
,0xAA,0x55,0x35,0x55,0x56,0x5A,0xAA,0xA9
,0x52,0xA6,0x55,0x56,0xAA,0xAA,0xA5,0x4A
,0xAA,0xAA,0xD3,0x55,0x55,0x56,0xAD,0x59
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x4A,0x95,0x2A,0xAA,0xAA,0xAA,0xAA,0x55
,0x55,0x55,0x6A,0xD5,0x52,0xAA,0xAA,0xAA
,0xAD,0x55,0x55,0x55,0x54,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0x95,0x54,0xAA,0xAA,0xAA
,0xAA,0xAB,0x55,0x55,0xAA,0xAA,0xAA,0xAA
,0xAA,0xB5,0x55,0x55,0x55,0x55,0x55,0x55
,0x4A,0xAA,0xAA,0x95,0x55,0x55,0x55,0x55
,0x6A,0xAA,0xAA,0xD5,0x55,0x55,0x2A,0xA9
,0x55,0x55,0xAA,0xA9,0x55,0x55,0x55,0x55
,0x55,0x29,0x55,0x55,0x55,0x56,0xAA,0xAA
,0xD2,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0x95,0x55,0x2A,0x96,0xD5,0x55
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xAA
,0xAA,0xAA,0xD5,0x55,0x55,0x55,0x55,0x54
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0x95,0x2A,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xB5,0x55,0x55
,0x4A,0xA5,0x54,0xAA,0xAA,0xAA,0xAA,0xAA
,0x55,0x55,0x55,0x55,0x6B,0x33,0x33,0x26
,0x66,0x66,0x66,0x6C,0xCC,0xCC,0xCC,0xCC
,0xC9,0x99,0x99,0x99,0x99,0x99,0x33,0x33
,0x33,0x33,0x73,0x66,0x66,0x66,0x66,0x66
,0x4C,0xCC,0xCC,0xCC,0xC9,0xD9,0x99,0x9B
,0x13,0x33,0x33,0x33,0x23,0x36,0x66,0x4C
,0xC6,0x66,0x66,0x6C,0xCC,0xCD,0x89,0x99
,0x99,0x99,0x9B,0xB3,0x33,0x33,0x33,0x33
,0x62,0x66,0x64,0xCD,0x85,0xCC,0x6C,0xCC
,0xD9,0x99,0x93,0x93,0xB1,0x33,0x33,0x32
,0x27,0x76,0x66,0x66,0x64,0x7C,0x4C,0xEC
,0xC4,0xCC,0xC9,0x99,0x99,0xB1,0xB3,0x33
,0x33,0x33,0x27,0xA2,0x36,0xE6,0x27,0x66
,0x64,0xAE,0x0E,0xE6,0x66,0x63,0x26,0x64
,0xCC,0xCC,0x9C,0xAE,0x36,0x5A,0x8D,0xD0
,0x9B,0xA9,0x2B,0x65,0x53,0x55,0xA3,0xCA
,0x63,0x36,0x27,0x4A,0xCC,0xC8,0xAB,0x4D
,0x66,0xAA,0x96,0xA9,0x53,0x55,0x55,0x55
,0x54,0xD5,0x55,0x99,0x99,0x99,0xB3,0x33
,0x33,0x33,0x26,0x47,0x83,0xE1,0xF0,0x7C
,0x1F,0x0F,0x03,0xE1,0xE0,0xF8,0x75,0x0F
,0x86,0xE3,0x72,0x76,0x6C,0x8D,0x8D,0xC3
,0x89,0xF0,0x7C,0x3E,0x0F,0x1F,0x03,0xE0
,0xF0,0x7E,0x0F,0x83,0xE0,0xFE,0x27,0x66
,0x64,0xCD,0x91,0x98,0xF3,0x1F,0x07,0xC4
,0xD5,0x37,0x03,0xF8,0x07,0xA5,0x70,0x7D
,0x10,0xF8,0xCC,0x6E,0xC4,0xE8,0x9B,0x33
,0x91,0xF0,0x5D,0xC1,0xF0,0x7E,0x03,0xE0
,0xE0,0xFE,0x07,0x91,0x78,0x1F,0x09,0xDC
,0xCC,0x8D,0x93,0x72,0x37,0x0E,0x51,0xF8
,0x3E,0x0F,0x83,0xE0,0xF0,0xF8,0x1F,0x03
,0xC1,0xF8,0x1E,0x0F,0x07,0x8B,0x2E,0x43
,0xF0,0x5F,0x07,0xE0,0xF8,0x78,0x6C,0xCA
,0xAD,0x4D,0xA9,0x5A,0x26,0x8E,0x86,0xB2
,0xA9,0x55,0x55,0x4D,0xD0,0xF8,0x3C,0xB5
,0x62,0xE5,0x36,0x95,0x98,0xAD,0x51,0xE5
,0x69,0xAA,0x89,0xCA,0x59,0x2D,0x92,0x76
,0x56,0x2E,0x45,0xAA,0xAA,0xAA,0xAD,0x4A
,0xD1,0xB8,0xBC,0x38,0x5D,0x54,0xAE,0xC0
,0xFE,0x07,0x83,0xE0,0xF1,0xE0,0xFC,0x1E
,0x07,0xE0,0x7C,0x1F,0x0F,0x87,0xC3,0x81
,0xF8,0x3E,0x07,0xE0,0xFC,0x3C,0x1E,0x0E
,0x9D,0x81,0xF0,0x7E,0x0F,0xC1,0xF0,0xF0
,0xF8,0x1E,0x5E,0x07,0xE0,0x7E,0x1F,0x07
,0x87,0x87,0x81,0xF0,0xBC,0x1F,0xC0,0xFC
,0x1C,0x3E,0x1A,0xF0,0x5E,0x81,0xE8,0x5B
,0x83,0xE1,0xE3,0x8F,0x07,0xA5,0x7A,0x1E
,0xAA,0x2F,0x0C,0x78,0xD0,0xF9,0x12,0xB3
,0x49,0xE9,0x51,0xE5,0x0E,0xB4,0x2E,0x5A
,0x0F,0x60,0xBD,0x54,0x7D,0xC2,0xB9,0x50
,0xF9,0x16,0xD5,0x47,0x6A,0x87,0x99,0x35
,0x54,0xA6,0xA9,0x2B,0x64,0xAB,0x47,0x1C
,0xF1,0x6D,0xA5,0xAC,0x85,0x7A,0x85,0x8F
,0x8C,0xF1,0x45,0xCA,0x90,0xBE,0xA4,0xD7
,0x4E,0x0D,0xC1,0xAB,0xA3,0x95,0xD4,0x8B
,0xAB,0x5C,0x1C,0xC7,0x8D,0x07,0x1D,0xD2
,0x2F,0x55,0x2C,0x3C,0x63,0x8C,0x4F,0x1D
,0x42,0xFD,0x12,0x2A,0xB8,0x73,0x87,0x97
,0x96,0x84,0xEA,0x8A,0xDB,0x58,0x79,0x4D
,0xC5,0x42,0xEA,0x36,0xA3,0xCA,0xD4,0x1C
,0x19,0x69,0xB2,0xB5,0x35,0x52,0xD5,0xB6
,0x2C,0x9A,0x95,0xAB,0x56,0xB4,0xA5,0x12
,0xB6,0xAA,0x70,0xB1,0x55,0x55,0x4B,0xA5
,0xB6,0x05,0x3F,0x07,0xC1,0xC3,0xF0,0x7C
,0x1F,0xC0,0xED,0x28,0xFC,0x1F,0x0F,0x03
,0xE0,0xFC,0x0F,0x80,0xAF,0xC0,0xFC,0x3C
,0x1F,0x03,0xE0,0xFE,0x0F,0x52,0x17,0xE1
,0xF0,0xF0,0x3E,0x07,0xE0,0xF9,0x15,0x74
,0x0F,0x87,0x4B,0xE0,0x7C,0x17,0x51,0x6A
,0xA1,0x78,0x5D,0x5B,0x2B,0xA4,0xD5,0x35
,0x55,0x55,0xA2,0xD2,0xAA,0xAA,0x4D,0xAA
,0xA9,0x55,0x95,0x56,0x95,0x49,0x55,0x55
,0x5B,0x69,0x55,0x55,0x54,0xEA,0x9A,0x5A
,0xAA,0xAC,0xAB,0x49,0x35,0x32,0xD6,0x62
,0xCB,0x15,0x4D,0x52,0xBB,0x22,0x8F,0x19
,0xDC,0x63,0xCB,0x43,0xE8,0x5B,0xA5,0x51
,0xE6,0x33,0x19,0x71,0xE0,0x7A,0x0E,0xE5
,0x54,0x79,0x8C,0xC6,0x5C,0xF8,0x3C,0x8B
,0x99,0x59,0x1E,0x67,0x33,0x2E,0x3D,0x0F
,0x41,0xEC,0x56,0x2F,0x89,0xCC,0x4A,0xCE
,0x87,0xA2,0xF1,0x19,0x8B,0xC6,0x77,0x32
,0xA3,0x89,0xE9,0x5C,0x86,0x69,0xF0,0x9C
,0xCF,0x1C,0x60,0xBC,0x96,0xB2,0x9A,0xBC
,0x19,0xCC,0x70,0xF0,0xB1,0xAC,0x87,0xF0
,0xB2,0xF1,0x1E,0x61,0xCE,0xE1,0xF4,0x2D
,0x89,0x55,0x87,0xC6,0x3A,0x38,0x74,0xB4
,0xAD,0x50,0xF4,0x8B,0xC3,0xCB,0x1E,0x47
,0x47,0x92,0x79,0x1E,0x92,0xE0,0xF8,0x69
,0x51,0xA9,0x6A,0x97,0x85,0xB2,0x74,0x97
,0x0D,0xA5,0x59,0x55,0x55,0x5A,0x5B,0x45
,0xE1,0xD2,0xB4,0xAD,0x2A,0x95,0x4B,0x51
,0x6A,0x2E,0x4F,0x4B,0x92,0xAA,0xA9,0x3A
,0x56,0xAA,0xC9,0xA9,0x59,0x6D,0x3A,0xAB
,0x25,0x52,0xB5,0x55,0x55,0x45,0x4A,0xD5
,0x6A,0xAA,0x55,0x4A,0xAA,0xB2,0xB2,0xAA
,0x54,0xAD,0x56,0xB5,0x6A,0x55,0x55,0x55
,0x55,0x4A,0xA5,0x55,0x55,0x55,0x54,0xAA
,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xD5,0x55,0x55,0x55,0x55,0x56
,0xAA,0x55,0x55,0x55,0x55,0x55,0x52,0xAA
,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55
,0x6A,0xAA,0xAA,0xAA,0xAA,0xA9,0x55,0x55
,0x56,0xAA,0xAA,0xAA,0x55,0x55,0x55,0x55
,0x55,0x2A,0x99,0xAA,0xAA,0xAA,0xAB,0x4C
,0xAC,0xB2,0x99,0x99,0x93,0x2E,0x55,0x59
,0x8D,0x33,0x64,0xE6,0x6C,0xCC,0x6D,0x19
,0x33,0x2C,0x73,0x3B,0x92,0x63,0x32,0xCC
,0xD5,0x58,0xE6,0x63,0x33,0xC8,0xD8,0x3E
,0x29,0xE6,0x49,0xC6,0x39,0x66,0x99,0xB2
,0x3A,0xCC,0xD1,0xB0,0xE3,0x39,0x8D,0x36
,0x98,0xE7,0x31,0xBE,0x63,0xCC,0x64,0xCD
,0x98,0xC6,0x73,0x07,0xD8,0x73,0x8C,0xD9
,0xC1,0x9C,0xC7,0x31,0x79,0x8C,0xAA,0xA4
,0xB8,0xBC,0x73,0x98,0xDE,0x07,0x19,0xE6
,0x1D,0x83,0xCE,0x33,0x89,0xE0,0x77,0x8C
,0xE1,0xBC,0x39,0x8E,0x71,0x6A,0xD3,0x1C
,0xC9,0x9C,0x3C,0x47,0x30,0xFC,0x8E,0x33
,0xC8,0x7B,0x07,0xCC,0x67,0x06,0xF0,0xD3
,0x59,0x87,0x84,0xF8,0xB5,0xAA,0x92,0x72
,0xCC,0x67,0x81,0xDC,0x39,0x8D,0xB8,0x17
,0x96,0x63,0x37,0x0D,0xE3,0x98,0x6E,0xC1
,0xBC,0x33,0x98,0xD5,0x29,0xA3,0x3C,0x93
,0xE3,0x1C,0x67,0x90,0x9E,0x27,0x86,0x73
,0x17,0xC4,0xF1,0x8C,0xCC,0xF6,0x1E,0x33
,0x98,0xD6,0x25,0x59,0xA4,0xEC,0x4F,0xC3
,0x31,0x9D,0x83,0xF0,0xE7,0x19,0xB1,0x3D
,0x0C,0xE3,0x3B,0x0F,0x61,0xCC,0x66,0x60
,0xF8,0x73,0x53,0x37,0x64,0x3C,0x47,0x31
,0x3E,0x87,0x8C,0xE6,0x27,0x60,0x79,0x8E
,0x63,0x6E,0x07,0x8C,0x67,0x26,0xD8,0xF4
,0xAA,0xA9,0x93,0xD0,0x73,0x99,0xD9,0x1D
,0x83,0x38,0xCD,0x91,0xD8,0x33,0x99,0xD9
,0x1D,0x83,0x39,0x8D,0x91,0xDC,0x39,0x8C
,0xA9,0xAC,0x7C,0x63,0x99,0x3B,0x09,0xC6
,0x73,0x19,0xB1,0x9E,0x33,0x98,0x37,0x83
,0xC6,0x73,0x0B,0xB1,0x4C,0x63,0x95,0xA6
,0x73,0x1C,0xE2,0x3C,0x47,0x91,0x9E,0x67
,0x60,0xEC,0x1C,0xC6,0x7C,0x87,0x71,0x9C
,0xC7,0x44,0x6E,0x19,0xC6,0x69,0x69,0x98
,0xC7,0x31,0x6E,0x33,0xCC,0xE6,0x16,0xE4
,0x3C,0xC7,0x31,0x9E,0x27,0x8C,0x73,0x17
,0x62,0x39,0x8E,0xE4,0xD4,0x51,0xCE,0x63
,0xB0,0xF3,0x1C,0xC6,0x33,0x25,0x71,0x9E
,0x63,0x33,0x87,0x18,0xCC,0x76,0x36,0x71
,0x8C,0x63,0x31,0xAA,0x9A,0xB8,0xEC,0x6D
,0x27,0x1C,0xE7,0x32,0x78,0xCC,0xB2,0xD2
,0x94,0xB4,0xB9,0x6B,0x18,0xD2,0xCC,0xA5
,0x55,0x55,0xAC,0xD2,0xA6,0x95,0x4A,0xAA
,0xD5,0x55,0xAB,0x25,0x35,0x95,0x55,0x56
,0xA9,0xAC,0xCA,0x94,0x99,0x59,0xCD,0x55
,0x6A,0xAA,0x54,0xA6,0xB5,0x53,0x55,0x59
,0x4D,0x29,0x4A,0x5A,0xD5,0xA6,0xAA,0xA9
,0xA5,0x2A,0xB6,0xA5,0xA9,0x66,0xA5,0x52
,0x52,0xD6,0xD5,0x56,0xAA,0xAA,0x95,0x2A
,0xAA,0xAB,0x55,0x55,0x52,0x94,0xAA,0xAA
,0xB5,0x6D,0x95,0x49,0x55,0x55,0x55,0x55
,0x55,0x55,0x54,0xA9,0x55,0x5A,0xAA,0xAB
,0x55,0x95,0x2A,0xAA,0xAA,0xAC,0xAA,0xA6
,0x55,0x55,0x2A,0xAD,0x55,0x5B,0x55,0x51
,0x55,0x65,0x66,0x69,0x6A,0xCA,0x4A,0xCA
,0x55,0x5A,0xAA,0xAD,0x55,0x25,0x55,0x55
,0x55,0x55,0x55,0x54,0xD4,0xAA,0xA6,0xAD
,0x56,0xAA,0xAA,0x95,0x55,0x55,0x4D,0x55
,0x55,0x55,0x29,0x55,0x55,0x5A,0xAA,0xAD
,0xA5,0x2A,0xA6,0xAA,0xAA,0xB4,0xD5,0x53
,0x2A,0xA5,0x55,0x56,0xAA,0xAD,0x55,0x4A
,0xAA,0xAA,0xAA,0xAA,0xB5,0x34,0xA9,0x55
,0x56,0xD9,0x4E,0x5A,0xAA,0x52,0x9B,0x2A
,0x67,0x2E,0x73,0x8C,0x99,0xA6,0x44,0xD6
,0x66,0xD6,0x95,0x2A,0xB6,0x32,0xCD,0x66
,0x72,0x55,0x4D,0x32,0xCE,0x9A,0xB2,0xB4
,0xD9,0x32,0x69,0x53,0xAC,0xD6,0x9A,0xC6
,0x94,0xA9,0xCC,0x99,0x9A,0xC9,0xAC,0x92
,0xD5,0x2B,0x55,0xAB,0x39,0x65,0x32,0xB3
,0x29,0x69,0x36,0xB5,0xAA,0x4D,0x49,0x6B
,0x6B,0x2A,0xD3,0x99,0x4A,0x96,0x5A,0xB5
,0x66,0xD5,0x54,0xCA,0xA5,0x95,0x95,0x34
,0xDA,0x4B,0x19,0x4B,0x4C,0xD6,0xD3,0x6C
,0x92,0x99,0xA9,0x5A,0x6A,0xAD,0x59,0x4A
,0x95,0x96,0x9B,0x52,0xD3,0x65,0xA4,0x93
,0x65,0x96,0xA9,0x6B,0x64,0xC9,0x49,0x6D
,0x4C,0xA5,0x7B,0x49,0x66,0x59,0x5A,0x55
,0x65,0xB6,0x64,0xAB,0x4D,0x29,0xCA,0x6A
,0x5E,0xD2,0xCA,0x65,0x6C,0x9A,0xD2,0xD3
,0xA9,0x51,0x4A,0xB2,0xD3,0x2E,0x5B,0x54
,0xAC,0x95,0x56,0x65,0x9B,0x33,0x34,0x99
,0x95,0x66,0x5A,0x9A,0xB6,0x69,0x92,0x6A
,0x92,0xCA,0xDA,0x4D,0xA4,0xAA,0x55,0x34
,0xB5,0xB4,0xCF,0x4A,0x59,0x4B,0x99,0x2D
,0x4B,0x56,0x94,0x96,0x59,0x4B,0x5B,0x2D
,0x39,0x6A,0x69,0x2D,0x2D,0x56,0xD2,0x6B
,0x4A,0x99,0x91,0xB4,0xB2,0xB5,0x66,0xCA
,0x62,0x6A,0x64,0xCD,0x95,0xA5,0x4C,0xAA
,0xA4,0xCA,0xAB,0x55,0xD3,0x6A,0x4A,0xB2
,0x55,0x56,0xAA,0xB2,0xA5,0x6A,0x55,0x55
,0x56,0x5A,0xB3,0x54,0xAA,0xAA,0x55,0x56
,0xAA,0xA9,0x55,0x55,0x49,0x6A,0xAA,0x9B
,0x66,0x55,0x2A,0xA6,0xAA,0xAA,0xAB,0x4A
,0x5B,0x24,0xD4,0xD3,0x66,0xCA,0xE9,0x34
,0xD3,0x4A,0xB2,0xCD,0x53,0x6C,0x89,0xB0
,0x99,0xB6,0x69,0x2B,0x76,0x5A,0x6A,0x8C
,0x2D,0x4F,0x48,0xD2,0xF2,0x89,0xA5,0x69
,0xAD,0x2B,0x5A,0x93,0xA2,0x69,0x36,0x73
,0x32,0xC5,0x9D,0x33,0x26,0x2D,0xE1,0x95
,0xB9,0x33,0x66,0x61,0x33,0x26,0x99,0x55
,0x53,0x4E,0x1C,0xF1,0x8E,0x5D,0x1C,0xB8
,0x3D,0xC9,0x8C,0xDB,0x90,0x3B,0x26,0x8C
,0xDA,0x42,0xE7,0x69,0xCC,0x96,0xD2,0x54
,0xD3,0xAC,0xB0,0x7C,0x86,0x8D,0x92,0xE0
,0x7E,0xC5,0x93,0xA6,0x03,0xF3,0x07,0xC4
,0xDC,0x3C,0x30,0xF8,0xB4,0x9A,0xDA,0xD9
,0x38,0x72,0x7C,0x1E,0x60,0xF8,0x8F,0x0F
,0x90,0x3E,0x26,0x7C,0x1E,0x70,0xF8,0x0F
,0x8E,0x3C,0x1F,0x24,0xF4,0x55,0x56,0x0F
,0xB0,0x6D,0xA3,0xD8,0xB3,0x07,0xC2,0x7F
,0x07,0x70,0x79,0x87,0xB0,0x7E,0x06,0xD0
,0xFE,0x0E,0x60,0xEA,0x55,0x67,0x83,0xE1
,0x3F,0x00,0xF8,0x1F,0x11,0xF2,0x4F,0x81
,0xF1,0x3F,0x04,0xF8,0x1F,0x21,0xF2,0x0F
,0x83,0xE1,0x3A,0xA6,0xAE,0xC4,0xCF,0x0D
,0xF0,0x7E,0x1C,0xE0,0xF7,0x07,0xC1,0xCF
,0x0D,0xF0,0x3F,0x06,0xF0,0x4F,0x83,0xE0
,0xEE,0x1D,0x4B,0x81,0xD9,0x87,0x90,0x7E
,0x0E,0x98,0xF8,0x23,0xE0,0x7C,0x8F,0xC8
,0x3F,0x07,0x4C,0x3E,0x09,0xF0,0x7C,0x27
,0x61,0x35,0x6A,0x4D,0xE0,0xDF,0x07,0xE0
,0xEC,0x8D,0xF0,0x3F,0x0F,0xB0,0x6F,0x81
,0xF0,0x76,0x83,0xF8,0x1F,0x87,0x31,0x35
,0x57,0x0F,0x4C,0x3E,0x49,0xF0,0x3C,0x49
,0xE4,0x9F,0x83,0xC6,0x4F,0x44,0xF8,0x3E
,0x29,0xF0,0x4F,0x83,0xC3,0x4F,0x26,0xC5
,0x92,0xCF,0x06,0xD8,0x3E,0x0E,0xD8,0x6D
,0x83,0xF0,0x76,0x83,0x6C,0x9F,0x07,0x36
,0x3E,0x44,0xF0,0xF2,0xC3,0xB2,0x54,0xB8
,0xE1,0xE2,0x5F,0x03,0xC7,0x1E,0x24,0xF8
,0x3E,0x33,0xF0,0x67,0x83,0xC3,0x1F,0x12
,0x7C,0x3C,0x38,0xF2,0x65,0x8D,0x59,0x70
,0xE9,0xA7,0x82,0xE7,0x06,0xD8,0x7C,0x36
,0x70,0x76,0xC3,0xE1,0x66,0xA6,0xE8,0x3E
,0x17,0x38,0x3A,0x65,0xAA,0x9C,0xBC,0x1B
,0x60,0xF0,0xC7,0xC5,0x9C,0x0F,0x0E,0x7C
,0x38,0xE0,0xF0,0xE3,0xC2,0xCF,0x07,0x86
,0x7C,0x4D,0xB1,0x65,0x58,0xBC,0xB0,0x78
,0xD8,0xC1,0xDB,0x27,0xC1,0x9E,0x1E,0x78
,0x7C,0x3C,0x60,0xF9,0x87,0xE2,0x67,0x07
,0x3C,0x36,0x54,0xC7,0x8D,0x9F,0x07,0x64
,0x3E,0x30,0xF8,0x3A,0x31,0xF1,0x47,0xC1
,0xD1,0x87,0x8E,0x3E,0x0E,0x1C,0x3C,0x71
,0xE1,0x6A,0xAE,0x2E,0x58,0xBC,0x3C,0x78
,0x73,0xE0,0xF1,0xE2,0xE2,0xCF,0x07,0xC7
,0x1B,0x07,0x3C,0x5F,0x0E,0x4E,0x1D,0xD1
,0x55,0x56,0xC6,0xC8,0x3B,0x8F,0x19,0x4B
,0x55,0x6A,0x5A,0xAA,0xAD,0x4A,0x95,0x6C
,0x9A,0x95,0x55,0x2D,0x54,0xAA,0xA5,0x95
,0x55,0x55,0xA9,0x55,0x2D,0x52,0xA9,0x56
,0xAA,0xAA,0xAA,0xAA,0x6A,0xA6,0xD2,0xD6
,0xAB,0x52,0xAD,0x2A,0xAA,0x5B,0x4B,0x6A
,0x55,0x26,0xD1,0x55,0x55,0x4A,0xD6,0x93
,0x34,0xAA,0xA9,0x55,0x2A,0xAA,0xAA,0x55
,0x4A,0xAA,0xAA,0xA6,0xD5,0x35,0x55,0x55
,0x55,0x25,0xB5,0xAA,0xAA,0x96,0xAA,0xB2
,0xAA,0xAB,0xA5,0x55,0x55,0x52,0xAA,0x96
,0xAA,0xD4,0xAA,0xAA,0xAA,0xAA,0xAA,0xAB
,0x4D,0x52,0xA5,0x54,0xAA,0xAD,0x55,0x55
,0x53,0x55,0x65,0x4D,0x29,0xC6,0xA9,0xD2
,0x70,0xF8,0x69,0x3A,0xAC,0xE1,0x71,0x6C
,0x39,0x9C,0x3E,0x31,0x87,0x33,0x87,0xC4
,0x70,0xE6,0xE3,0xB8,0x8E,0x38,0xBC,0x67
,0x23,0x8F,0x35,0x4A,0x97,0x0E,0x19,0x3C
,0xC3,0xE1,0xC7,0x0F,0x18,0xE4,0x38,0xE1
,0xE7,0x1C,0x87,0x18,0x39,0xC7,0x31,0xE7
,0x16,0x69,0x29,0xC7,0x1B,0x38,0xE7,0x18
,0xE3,0x66,0x38,0xC7,0x9C,0x6C,0xC3,0x9C
,0x63,0x8D,0x98,0xE7,0x1C,0x71,0x93,0x1C
,0xCA,0xB1,0xCD,0x98,0x67,0x8E,0x31,0xF3
,0x8C,0xF1,0xC6,0x3E,0x61,0x9E,0x38,0xC7
,0xCC,0x33,0xC7,0x18,0xF1,0x86,0xF1,0xC6
,0xA9,0x9E,0x31,0xE3,0x1C,0x39,0xE6,0x1C
,0x63,0x93,0x3C,0xC3,0x8E,0x38,0xE3,0x8C
,0xF1,0x87,0x64,0xF1,0x8F,0x19,0xAA,0xB0
,0xCC,0x9C,0x73,0x37,0x0C,0xE1,0x8E,0x34
,0x61,0x9E,0x18,0xE3,0x2E,0x19,0xE1,0x8E
,0x33,0x64,0xDC,0x9C,0xE3,0x1B,0x2B,0x36
,0x39,0xC6,0x0F,0xB0,0xF3,0x0E,0x70,0xF9
,0x8F,0x18,0xE7,0x06,0xD8,0xD8,0xC7,0x38
,0x76,0xC5,0xCC,0x3B,0x55,0x99,0x93,0x1C
,0x63,0xC4,0x9E,0x4C,0xF1,0x1E,0x26,0x6C
,0x67,0x8C,0xB3,0x33,0xA3,0x2C,0x69,0x8C
,0x9E,0x1D,0xA3,0x4D,0x55,0x95,0x99,0x33
,0xC6,0x74,0x4E,0x69,0xCB,0x13,0xB0,0xD9
,0x26,0x7C,0xC6,0xC6,0xE4,0x9B,0x73,0x33
,0x1B,0x16,0x6A,0xA5,0x53,0x93,0x36,0x49
,0xCE,0x1E,0x4C,0xD9,0x67,0x32,0x39,0x32
,0xE5,0x98,0xE9,0xB4,0xCB,0x96,0x71,0xA3
,0x93,0x36,0x56,0xAA,0x71,0xB3,0x66,0x99
,0xA5,0xD2,0x4C,0x9B,0x66,0x36,0x1B,0x36
,0x69,0x9A,0x5C,0x64,0xD1,0x66,0x6B,0x64
,0xAB,0x56,0x66,0xD2,0x39,0x36,0xC9,0x33
,0xC9,0xCD,0x9A,0x4C,0xDA,0x47,0x26,0xF8
,0x33,0x59,0x39,0x33,0xC9,0x96,0x65,0xC9
,0xC9,0x33,0x69,0x91,0xB3,0x2D,0x99,0x66
,0xC5,0x99,0x6C,0xC3,0x6E,0x3C,0xC5,0x66
,0x3B,0x71,0xC6,0x6E,0x61,0x9B,0x86,0x9C
,0x8C,0xE3,0x83,0x3C,0x6C,0x65,0xC6,0x38
,0xE7,0x66,0x2E,0x63,0x87,0x3B,0x18,0x73
,0x8E,0x5C,0x68,0xC7,0x8D,0x32,0xD9,0x99
,0x63,0x8E,0x56,0x64,0x73,0x8E,0x33,0x71
,0x93,0x8E,0x38,0xCD,0xCE,0x4E,0x71,0xE3
,0x2E,0x72,0x73,0x0F,0x32,0xD8,0xC8,0xCB
,0x2C,0x70,0xD6,0xC6,0x18,0xE3,0x8E,0x68
,0x65,0x8E,0x38,0xCF,0x06,0x78,0xC7,0x0C
,0xF9,0x63,0x9C,0x71,0xCA,0xC9,0x8E,0x31
,0xE3,0x0E,0x98,0xC7,0x1E,0x21,0xDD,0x8D
,0x33,0xE6,0x4C,0xC9,0x9B,0x2E,0x64,0xD8
,0x9D,0x25,0xC4,0xB7,0x36,0x65,0xC1,0xDC
,0x3D,0x83,0x4E,0x1C,0xD9,0xC9,0x36,0x60
,0xCC,0x9E,0xC9,0xB6,0x0E,0xCC,0xE6,0x1B
,0x24,0xF5,0x4D,0x4B,0x06,0xF0,0xD9,0x8C
,0xF2,0x3D,0x86,0xE6,0x67,0x83,0xF0,0x5C
,0xC6,0xF0,0x3E,0x86,0x72,0x3F,0x03,0xD8
,0x66,0x59,0x96,0xC4,0xBC,0x8E,0xC8,0xBE
,0x03,0xD8,0xEC,0x8F,0xC1,0x3C,0xCF,0x60
,0xDE,0x03,0xCC,0x76,0x4E,0x60,0xDE,0x46
,0x62,0xB4,0xE6,0x33,0x99,0xB2,0x9F,0x21
,0xB8,0xCD,0x94,0x7A,0x1B,0x88,0xDB,0x0F
,0xB0,0xDC,0x87,0xC8,0x7A,0x0D,0xCA,0xAA
,0xB8,0x67,0x91,0x9C,0x4F,0xC0,0xF9,0x1D
,0x91,0x7C,0x07,0xC8,0xDE,0x0F,0x60,0x9E
,0xC6,0x70,0x9F,0x82,0xF4,0x37,0x15,0x53
,0x58,0xCE,0x66,0xD9,0x1E,0x62,0x73,0x96
,0xC8,0xF9,0x99,0xCC,0xDB,0x27,0x6C,0xCE
,0x66,0xD9,0x1F,0x22,0x72,0x95,0x96,0x92
,0x66,0x63,0x64,0xDC,0x49,0x98,0xDD,0x93
,0x70,0x4C,0xC6,0x6C,0x93,0xC8,0x77,0x19
,0xB2,0x6B,0x09,0xD8,0xCD,0x55,0x86,0xD9
,0x98,0xC9,0xB2,0x9B,0x44,0xE6,0x65,0xD8
,0x5F,0x31,0x99,0x37,0x43,0x78,0x8D,0xC8
,0xBB,0x1A,0xE6,0x55,0x99,0x32,0xD0,0xEE
,0x46,0xE8,0x9E,0x83,0x31,0x9B,0x26,0x78
,0x19,0xCC,0xD9,0x13,0x90,0xEE,0x26,0x6C
,0x9C,0x93,0x62,0xAA,0x9B,0x1B,0x66,0x67
,0x26,0xCC,0x5F,0x23,0x99,0x36,0xD2,0x79
,0x9C,0xC9,0xB3,0x17,0xCC,0xCE,0x4D,0xB0
,0xAC,0xA9,0x99,0xB2,0x5B,0x19,0xCC,0xCD
,0x86,0xB0,0xCE,0x66,0xC9,0x2D,0x86,0xE6
,0x66,0xC3,0x4C,0x66,0x33,0x6C,0x96,0xC6
,0xC6,0x59,0xA6,0x93,0x99,0xCC,0x9B,0x69
,0x39,0x9C,0xC9,0xBC,0x93,0x33,0x99,0xB6
,0xC3,0x72,0x39,0x93,0x5B,0x26,0x67,0x29
,0xA6,0x5B,0x1B,0x19,0x9A,0xCB,0x26,0x71
,0x33,0x49,0x74,0x4E,0x66,0x6A,0x2D,0x99
,0x8C,0xDA,0x4D,0xB3,0x61,0x97,0x13,0x55
,0x73,0x99,0x27,0x94,0x64,0xF2,0x66,0x74
,0xB9,0x3C,0x99,0x79,0x26,0x4F,0x26,0x5E
,0xC9,0x93,0xC9,0x8D,0xB2,0xAA,0x9B,0x35
,0x23,0x8D,0xC4,0xCE,0x68,0xD3,0x71,0x36
,0x70,0x69,0x9C,0x99,0x9C,0x16,0x6D,0x24
,0xD7,0x0A,0x3E,0xC3,0x65,0x2B,0x32,0xC7
,0x65,0x4F,0x99,0x23,0xB2,0x93,0xCC,0x90
,0xD9,0xC9,0xF6,0x48,0x6C,0xE4,0xDB,0x26
,0x37,0x52,0x5A,0x95,0x66,0xCE,0xC9,0x36
,0xB2,0x53,0x68,0x37,0x71,0x33,0x6C,0x3B
,0x31,0x33,0x34,0x9B,0x39,0x19,0xB4,0x99
,0xB8,0x93,0x32,0xAA,0xC6,0xE4,0x4D,0x64
,0x66,0x66,0x4B,0xA6,0x66,0x66,0x65,0xB6
,0x63,0x76,0x65,0xB6,0x33,0x76,0x61,0xB2
,0x3B,0x65,0x59,0x4C,0xCE,0x4C,0xDC,0xA4
,0xE6,0x44,0xCE,0x46,0xE6,0x66,0x4C,0x63
,0x73,0x13,0x67,0x29,0x39,0x99,0xA7,0x28
,0xD8,0xD3,0x34,0xE6,0x99,0x9C,0xCD,0x26
,0x63,0x33,0x33,0x99,0x9B,0x23,0x33,0x39
,0x93,0x39,0x99,0x99,0xA9,0x93,0x32,0xAA
,0xAD,0x55,0x55,0x52,0xAA,0x55,0x55,0x55
,0x6A,0xAA,0xAA,0xAA,0xAA,0xAA,0xAD,0x55
,0x4A,0xAA,0xA5,0x55,0x55,0x54,0xAB,0x2A
,0x95,0x55,0x2C,0xCA,0xD5,0x55,0x53,0x55
,0x2A,0x55,0x55,0x56,0x6A,0xAA,0xAA,0xD5
,0x55,0x6A,0xAC,0xAA,0xCA,0xA5,0x6B,0x2A
,0x9B,0x55,0x55,0x92,0x5A,0xAA,0xA9,0x55
,0xAA,0xAA,0xA5,0x55,0x55,0x2A,0xAA,0x95
,0x6A,0x92,0xAA,0xAD,0x49,0x55,0xB5,0x26
,0xAA,0xD5,0x55,0x5A,0xA4,0xD6,0xAA,0x95
,0x6A,0x9A,0xA5,0x6A,0xAA,0x55,0xB2,0x55
,0x65,0x55,0x52,0x6D,0x54,0x96,0xA9,0x55
,0x55,0x35,0x55,0xAA,0x4A,0xB4,0xAA,0xAB
,0x55,0x55,0xA9,0x2A,0xAB,0x5A,0x4A,0xB9
,0x55,0x55,0x55,0x6A,0x95,0x56,0x52,0xBA
,0xA4,0xAA,0xAA,0xD2,0x4C,0xED,0x4A,0x4D
,0x32,0xD2,0xAD,0xA2,0x36,0xB5,0x2D,0x36
,0x59,0x99,0x55,0xDA,0x46,0xE4,0xAB,0x34
,0xCE,0xCB,0x29,0xB2,0x29,0x36,0x96,0x6A
,0x99,0x56,0xDA,0x52,0xB9,0x2C,0xAC,0xB2
,0xCA,0xA9,0x52,0x5B,0x59,0xA4,0x96,0x96
,0xA6,0x6E,0x5B,0x25,0x99,0xA9,0x36,0xD9
,0x12,0x6D,0xB6,0x4A,0xAD,0xA6,0x52,0xD3
,0xB5,0x2A,0x52,0xCB,0x2D,0x2B,0x49,0x72
,0xD6,0x4A,0x9A,0x5A,0xCA,0xA6,0xB6,0x99
,0x2D,0x4B,0x4C,0xB2,0x9A,0xB6,0xB5,0x32
,0x96,0x59,0x5A,0x32,0xE7,0x92,0x99,0x93
,0x24,0xCA,0x97,0x6C,0xC6,0x92,0xCD,0x9B
,0x1B,0x26,0xD3,0x13,0x55,0x55,0x55,0x55
,0x36,0xB5,0x99,0x94,0xCB,0x69,0xD3,0x39
,0x74,0x99,0x9A,0x56,0x69,0x94,0xB5,0x4D
,0x65,0x32,0xCC,0xB4,0xAC,0xAA,0xAC,0xA9
,0x4D,0x65,0x6A,0xA5,0x55,0x54,0xD5,0x5A
,0xAA,0xAA,0xA9,0x56,0xAA,0xD5,0x55,0x55
,0x55,0x52,0xAD,0x95,0x55,0x55,0x55,0x59
,0x4A,0xA5,0x55,0x65,0x55,0x55,0x32,0x95
,0x56,0xAA,0xCA,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xB5,0x5A,0x95,0x4A,0x5A,0xAA
,0xB5,0x55,0x4D,0x52,0xAA,0xAA,0xAA,0xAA
,0xAA,0x67,0x2A,0xAA,0x99,0x94,0xE4,0xD6
,0x56,0xAA,0xAA,0x95,0x4C,0xCD,0x55,0x65
,0xA9,0x99,0x99,0x8C,0xCC,0x6A,0xD3,0x53
,0x95,0x33,0x8C,0xCA,0xAC,0xCE,0x56,0x36
,0x33,0x98,0xD8,0xCC,0xCD,0xCA,0xC7,0x26
,0x66,0x36,0x56,0xA9,0x5A,0xAB,0x19,0xA9
,0x99,0x9C,0x56,0x9C,0xAC,0xCC,0xCC,0x66
,0x66,0x66,0x66,0x66,0x66,0x55,0x65,0x69
,0x5A,0x8F,0x23,0xC4,0xF1,0x36,0x53,0x91
,0xD3,0x39,0x1D,0x19,0xA9,0x98,0xD9,0x99
,0xA9,0xC8,0xD8,0xAC,0xC6,0xCA,0xD5,0x2C
,0x6A,0x66,0x6D,0x27,0x4D,0x66,0x66,0x56
,0x47,0x46,0xCC,0xE4,0xE6,0x4E,0x4E,0x4D
,0x4C,0xCC,0xE4,0xCC,0x6C,0xB1,0x9C,0x9B
,0x33,0x91,0xE2,0x76,0x36,0x26,0xC6,0xCC
,0xCC,0xCC,0xD8,0xD9,0x3A,0x1B,0x27,0xA3
,0x60,0xEC,0x6C,0x3A,0x39,0x9B,0x33,0x27
,0x14,0xE1,0xE4,0xDC,0xB9,0x93,0x93,0x32
,0xE2,0xE6,0x6C,0x78,0x9C,0x1E,0x87,0xC3
,0xB2,0x72,0x74,0x6C,0x4C,0xCD,0x8B,0x93
,0x71,0x70,0xE4,0xCC,0xAB,0x8B,0x93,0xC6
,0x68,0xE5,0x99,0x39,0x36,0x66,0x66,0x99
,0x99,0x1E,0x2E,0x4E,0xC5,0x93,0xB0,0xE2
,0x7C,0x5C,0x9F,0x17,0x07,0x46,0xC9,0xD2
,0xB2,0x72,0xAC,0xB1,0xC6,0xCC,0xE2,0x72
,0x6C,0x3D,0x1B,0x1A,0x4E,0xC9,0x93,0x63
,0x66,0xC9,0xB3,0x2A,0x4C,0xD9,0xB2,0x64
,0xD8,0x9B,0x36,0x6C,0xC9,0x93,0x26,0xCD
,0x99,0x39,0x64,0xC9,0x9A,0x66,0xC7,0x93
,0x87,0x43,0x93,0xC3,0x93,0xA2,0xC9,0xB1
,0xE4,0xC9,0xB2,0x64,0xD8,0xB4,0x6C,0xD8
,0x74,0x6C,0x78,0x7C,0x58,0xBA,0x6C,0x99
,0x3E,0x5C,0x9B,0x2E,0x4E,0x97,0x2E,0x0B
,0x96,0x2D,0x5B,0x06,0x9D,0x0E,0x65,0x68
,0xD9,0x62,0xD1,0xE2,0xD1,0xB1,0xE9,0xD3
,0xA1,0xD3,0xA5,0xC3,0x66,0xC7,0x26,0xCD
,0x96,0x4E,0x95,0x2E,0x9D,0x1E,0x1C,0x38
,0x78,0x7A,0x78,0x78,0x70,0xF0,0xF1,0xE1
,0xF1,0xC1,0xC3,0xC7,0x87,0x8F,0x15,0x8B
,0x17,0x3A,0x2D,0x1E,0x2C,0xD4,0xDA,0xB5
,0x1A,0x25,0x72,0xED,0x52,0x89,0x34,0xD9
,0x66,0xC7,0x44,0x9B,0x2F,0x36,0x4C,0x94
,0xD9,0x3A,0x74,0xAA,0x61,0xE6,0xCB,0x8D
,0x32,0x53,0x65,0x9E,0x9B,0x16,0x34,0x78
,0xF1,0xE1,0xC6,0xCB,0x8E,0x9A,0x4C,0x74
,0xD9,0x6C,0xB2,0xC1,0x87,0x8E,0x4E,0x1C
,0x38,0x70,0xE3,0xC7,0x87,0x1E,0x1C,0x78
,0xF1,0xC3,0xC7,0x1F,0x3C,0x30,0xD1,0xC3
,0xE6,0x96,0x1A,0x68,0xF1,0xD3,0xCB,0x0E
,0x1C,0x78,0xE9,0xA7,0x8F,0x1C,0x38,0xD8
,0xE3,0x8F,0x1E,0x38,0xF0,0xE2,0xCB,0x1E
,0x69,0x31,0xA6,0x93,0x5A,0x49,0x39,0xA5
,0xB2,0x4E,0x36,0x66,0xC6,0x9A,0x69,0xC9
,0x96,0x9A,0x72,0xC7,0x4F,0x18,0x79,0x63
,0xCD,0x2C,0x3C,0xB1,0xC7,0x9E,0x38,0xE3
,0xC7,0x1C,0x39,0xC3,0x8E,0x78,0x69,0xC9
,0x39,0x69,0xA6,0x94,0xB4,0xD3,0x96,0x39
,0xE5,0x86,0x38,0xA5,0xAF,0x2C,0xB1,0xC3
,0x0E,0x72,0xDB,0x56,0x5A,0x48,0xD3,0x4E
,0x3C,0xD3,0x0E,0x38,0xE3,0x96,0x6D,0xA5
,0x30,0xE5,0x9E,0x78,0xC6,0x9C,0x31,0xC6
,0x9C,0x71,0xCE,0x58,0xD3,0x4C,0xB2,0x97
,0x29,0xE5,0x9E,0x71,0xC7,0x1C,0xE1,0x8E
,0x38,0x6B,0x1C,0x73,0x8E,0x38,0xC7,0x1C
,0xE3,0x8E,0x31,0x86,0xB8,0xE3,0x4E,0x64
,0xB4,0x9A,0x79,0xCF,0x38,0xE3,0x0C,0x71
,0xC7,0x3C,0xE3,0x18,0x63,0x9E,0xD2,0xD2
,0x49,0x2C,0xB5,0xCE,0x38,0xC7,0x18,0xC3
,0xDE,0x69,0x2C,0x25,0xA7,0x3C,0xE7,0x29
,0x63,0x18,0xE7,0x39,0xC6,0x59,0x4C,0x77
,0x3C,0xE7,0x18,0xC6,0x39,0xCE,0x71,0x8C
,0x61,0x9C,0xE7,0x39,0x8C,0x63,0x1C,0xE7
,0x18,0xE6,0x38,0xC6,0x73,0x9C,0x63,0x18
,0xCE,0x31,0x9C,0xA9,0xCE,0x31,0xCC,0x63
,0x19,0xCE,0x31,0x29,0x4E,0x6B,0x59,0xCE
,0x33,0x18,0xE6,0x33,0x9C,0x43,0x53,0x8E
,0xD4,0xE3,0x8C,0xC6,0x33,0x9C,0x67,0x29
,0x4C,0xAE,0xF6,0x31,0x8D,0x29,0xCE,0x73
,0x18,0xC6,0x27,0x6B,0x79,0x8C,0x46,0x73
,0x9D,0x8C,0x66,0x33,0x98,0xCC,0xE5,0x63
,0x19,0x9C,0xE7,0x33,0x19,0x8C,0xE6,0x71
,0x2A,0xD6,0x31,0x9C,0xED,0x6A,0x56,0xA7
,0x39,0x98,0xC7,0x52,0xAC,0x66,0x35,0x6B
,0x53,0x98,0xAD,0x4A,0xDC,0xE6,0x65,0x2A
,0x95,0xA9,0xCE,0x66,0x23,0x2B,0x76,0xA5
,0x23,0x52,0xB5,0x56,0xB3,0x19,0x98,0xCE
,0xD6,0x98,0x8C,0xD6,0xAB,0x19,0x98,0xCC
,0x9D,0xCC,0xCC,0x46,0xAB,0x54,0xE6,0x66
,0x73,0x2A,0x75,0x32,0x95,0xCA,0xCC,0x56
,0xAA,0xDD,0x8C,0xCC,0xA9,0x55,0x6A,0xB5
,0x52,0xA9,0x56,0xE6,0x56,0x2A,0xD4,0xCC
,0xCC,0xCC,0x8D,0xDD,0x98,0x8C,0x4C,0x6E
,0x66,0xD5,0x88,0xD6,0x73,0x33,0x33,0x19
,0x99,0x9B,0x32,0x66,0x59,0x99,0x99,0x99
,0x99,0x33,0x65,0x99,0x99,0xCC,0xCC,0xCC
,0xC6,0x66,0x6A,0x99,0x99,0xB2,0xCC,0xCD
,0x99,0x36,0x4C,0xB3,0x33,0x33,0x33,0x33
,0x33,0x26,0xCD,0x9B,0x26,0x66,0x66,0x66
,0xCC,0x99,0x35,0x99,0x99,0x99,0x99,0xB3
,0x49,0x99,0x93,0x64,0xCD,0x99,0x99,0x99
,0x99,0x99,0x36,0xCC,0xCC,0xD9,0x99,0x99
,0x9B,0x24,0xCD,0x99,0x99,0x35,0x59,0x36
,0x4C,0xD9,0x34,0xD9,0x93,0x32,0x65,0x93
,0x65,0x32,0x66,0xCC,0xC9,0xB2,0x49,0xAC
,0x99,0xB3,0x36,0x64,0xD6,0x65,0x66,0x4C
,0x9B,0x1A,0x59,0x34,0xD9,0x33,0x36,0x6C
,0xAC,0x93,0x4D,0x93,0x32,0x6C,0xC9,0x93
,0x4D,0x32,0x76,0x4C,0xD9,0x34,0x9B,0x33
,0x66,0xCC,0x9B,0x49,0xA5,0xB2,0x66,0xC9
,0xA9,0x95,0x9B,0x64,0xC9,0xA5,0xB2,0xB2
,0x4D,0x93,0x6D,0x26,0xA4,0xD9,0xB2,0x4D
,0x69,0x99,0x93,0x64,0xDA,0x5B,0x49,0x65
,0x99,0x93,0x6C,0xB4,0xAD,0xB2,0x64,0x96
,0xCB,0x26,0xD9,0x36,0x4D,0x65,0x53,0x64
,0xDB,0x65,0x2C,0x9B,0x36,0x59,0x96,0x56
,0xA6,0x93,0x64,0xD4,0xD3,0x25,0x95,0x35
,0x55,0x93,0x4C,0x96,0x59,0xA5,0xA6,0x4B
,0x36,0x59,0x52,0x6C,0x9B,0x2C,0x9A,0x6B
,0x4C,0xB5,0x4B,0x4B,0x4C,0xB5,0x69,0x49
,0x6C,0xB6,0x49,0x69,0x6D,0x96,0x4B,0x2C
,0xD5,0x52,0xD3,0x2D,0x96,0x96,0x93,0x4D
,0x59,0x65,0xA6,0x55,0x56,0xCA,0x69,0xA5
,0x69,0x65,0x92,0xCB,0x34,0xD3,0x2C,0xB4
,0xD5,0x56,0x95,0x55,0x9A,0xD2,0xA9,0x53
,0x4B,0x49,0x69,0x6D,0x69,0x34,0x96,0xCB
,0x34,0x96,0x9A,0xD4,0xB2,0xA9,0x66,0xB2
,0xA5,0xA5,0xA5,0xA5,0xA9,0xA5,0x2C,0xB5
,0x52,0xCA,0xAD,0x35,0x32,0xAA,0x6B,0x2A
,0x95,0x96,0xAB,0x29,0x55,0x5A,0xD2,0x95
,0x56,0xAC,0xA9,0x2D,0x56,0x95,0x53,0x4A
,0xAB,0x4A,0xAA,0xA5,0xAA,0xAA,0x9A,0x55
,0x55,0x55,0x4B,0x55,0x69,0xA9,0x55,0x6A
,0xAD,0x2A,0xAC,0xAD,0x4A,0x96,0xAA,0xAA
,0x96,0x9A,0xAA,0x9A,0xAA,0xAA,0xA1,0xF2
,0x53,0xE1,0x2F,0xA5,0x4A,0x68,0xE4,0xB4
,0xB2,0xD6,0xA2,0xE9,0x56,0xAA,0xA5,0x55
,0x91,0x55,0xAA,0xDA,0x2A,0xB2,0xAA,0xAA
,0xA8,0xB6,0xA9,0x55,0xA9,0x55,0x56,0xAA
,0xB4,0xA5,0x6B,0xB2,0x55,0x52,0xD5,0x6A
,0xA5,0x55,0x55,0x56,0xD5,0x2A,0xA6,0xAA
,0xAA,0xAA,0xD6,0x95,0x55,0x41,0xF2,0x59
,0x13,0xC9,0xBA,0x91,0x75,0x9B,0x19,0x32
,0x4F,0x16,0x49,0x37,0x93,0x74,0x93,0x4D
,0xA6,0xCB,0x62,0xA3,0x66,0xA6,0xD1,0x26
,0xD5,0xB8,0x7C,0x25,0xAD,0x4B,0x92,0x79
,0x2E,0x87,0x33,0x36,0x1A,0xB1,0xD4,0xED
,0x63,0x27,0x93,0x96,0x54,0xD3,0x66,0x73
,0x2D,0x42,0x79,0x76,0x39,0x95,0x0E,0x69
,0x64,0xCC,0xB3,0x75,0x9A,0x39,0x28,0xDD
,0x38,0xE1,0x25,0x9D,0xB9,0x6C,0x41,0xE4
,0x7F,0x84,0x30,0xD7,0xF3,0x68,0x38,0x85
,0xEC,0xD9,0x99,0x22,0x4D,0xF9,0x67,0x8C
,0x3C,0x61,0x83,0x1D,0x4F,0x1E,0x98,0x70
,0xE2,0x9C,0xF4,0xF3,0x0D,0x18,0x71,0xCF
,0x4E,0xD3,0xC2,0xC3,0x94,0x38,0xE5,0x8E
,0x29,0x22,0x3F,0x39,0xCB,0xCF,0x38,0x61
,0x82,0xCF,0x2E,0x70,0xE1,0xCD,0x1C,0xF3
,0x8F,0x2C,0xB0,0xC9,0xAB,0x3A,0x72,0x86
,0x34,0xB4,0xA6,0x3D,0x67,0x4C,0x69,0x56
,0xB3,0xCB,0x47,0x04,0xE3,0xC5,0x3A,0xCB
,0x32,0x96,0x52,0x97,0x1F,0x65,0x0C,0xC6
,0xCB,0x33,0xA4,0xC6,0x6C,0xEC,0x99,0xB3
,0x66,0x26,0x6C,0xD4,0xD9,0x99,0x31,0x66
,0x9C,0x58,0xDB,0x19,0x56,0x3C,0x72,0xCD
,0x8D,0x4B,0x19,0xC6,0x93,0x65,0x64,0xCD
,0xCB,0x1A,0xE3,0x2D,0x55,0x6A,0x59,0x19
,0xA6,0x54,0xCA,0x5C,0x9A,0xB5,0x66,0x98
,0xD5,0xAC,0xB5,0x36,0x4E,0x4D,0x8A,0xA6
,0x6A,0x6A,0x9A,0x9B,0x2A,0xC6,0xB4,0xCB
,0x25,0x2C,0xD3,0x16,0x63,0x59,0xAA,0x9A
,0xA7,0x2C,0xCA,0xD9,0x96,0x39,0x87,0x27
,0x8B,0x49,0xCC,0xD1,0x9B,0x2C,0xCE,0xC6
,0x93,0x65,0x26,0x9A,0xA7,0x26,0x99,0x99
,0x96,0x5A,0x65,0xCD,0x99,0x5A,0x65,0x99
,0x96,0x59,0x6C,0xA9,0x8D,0x27,0x2C,0xD9
,0x59,0x66,0x35,0x35,0x63,0x96,0x63,0x63
,0x96,0x59,0x8D,0x96,0x59,0x63,0x8D,0x38
,0x73,0x4E,0x4D,0x29,0xC6,0xC6,0xA6,0x3C
,0x4E,0x53,0x8D,0xA6,0x53,0xC5,0x35,0x1C
,0x63,0x97,0x1A,0x56,0x59,0xA6,0x5C,0xAD
,0x8D,0xAB,0x25,0x4B,0x33,0x1B,0x4A,0x59
,0x4B,0x56,0x94,0xD5,0x38,0xD5,0x69,0x9B
,0x33,0x29,0xAA,0x96,0x59,0x33,0x54,0xD2
,0xAC,0xCA,0xAB,0x2C,0xD3,0x32,0xAA,0x99
,0x99,0x55,0x4D,0x99,0x55,0x69,0x9A,0x9A
,0x66,0x4D,0x99,0x65,0x4C,0xD2,0x99,0xA7
,0x19,0x95,0x93,0x52,0x72,0xB1,0xAA,0x71
,0xA6,0x95,0x8E,0x66,0xA8,0xCD,0x8E,0x55
,0x99,0xA5,0xCA,0xB2,0xCC,0xB3,0x2C,0xC6
,0xA5,0x56,0x55,0x59,0x69,0x59,0xA6,0x66
,0x9A,0x63,0x35,0x96,0x65,0x69,0x65,0x96
,0x66,0x66,0x56,0x59,0x66,0x69,0x9C,0xAA
,0x9A,0x96,0x95,0x99,0x63,0x35,0x55,0x56
,0x65,0x33,0x4C,0xD3,0x19,0x66,0x69,0x8C
,0xD2,0xD8,0xCD,0x53,0x59,0x4D,0x59,0x59
,0x65,0x93,0x4C,0xC9,0x99,0xAA,0x65,0x99
,0x55,0x33,0x95,0x55,0x35,0x35,0x35,0x55
,0x65,0x35,0x56,0x53,0x4C,0xD3,0x34,0xD5
,0x35,0x55,0x55,0x55,0x55,0x55,0x56,0x66
,0x65,0x54,0xD6,0x65,0x54,0xCD,0x55,0x8D
,0x53,0x58,0xD5,0x33,0x34,0xB5,0x33,0x54
,0xD5,0x53,0x4C,0xCD,0x2B,0x2C,0xCB,0x33
,0x4A,0xAB,0x1A,0xCB,0x4B,0x2A,0xA6,0x69
,0x55,0x34,0xAC,0xAA,0x95,0x95,0x8C,0xD3
,0x34,0xCC,0xD3,0x32,0xAA,0xAA,0xAA,0xAC
,0xAA,0x71,0xAA,0x6B,0x2A,0xAA,0xAA,0xAA
,0xAA,0xAC,0xCA,0xC9,0xAA,0xAA,0xAA,0xAB
,0x2A,0x9A,0xB3,0x33,0x2A,0xB3,0x32,0xCB
,0x53,0x4D,0x4D,0x59,0x8D,0x53,0x5A,0x99
,0x59,0x99,0x69,0x4D,0x55,0x2D,0x4C,0xAC
,0xCC,0xE5,0x54,0xCC,0xCD,0x39,0x33,0x59
,0x55,0x53,0x35,0x65,0x56,0x66,0x54,0xCC
,0xB3,0x2A,0xCA,0xCC,0xA9,0xA9,0xA9,0x9A
,0xAA,0xAA,0xAA,0xAA,0xAA,0xCA,0xAC,0xAA
,0xAB,0x2C,0xAC,0xB2,0xAA,0xCA,0xAA,0x55
,0xAA,0x96,0xAA,0xAA,0xAA,0xAA,0xCA,0xAB
,0x4B,0x53,0x5B,0x8B,0x32,0xA8,0x5D,0xCA
,0x96,0x98,0x12,0x6C,0xA3,0xB9,0x6D,0xCB
,0xB5,0x2C,0x90,0x97,0xA5,0xB0,0xFE,0x1C
,0x1C,0x3F,0x7B,0xBA,0x45,0xA5,0x51,0x04
,0x9D,0x28,0x22,0x4B,0xC9,0x52,0x91,0xAA
,0x82,0xD6,0x4A,0xD5,0x04,0x55,0x2B,0x6E
,0xF6,0xEA,0xF6,0xA5,0x35,0x76,0xDD,0xAB
,0x7B,0x6D,0xDB,0x56,0xDB,0xAD,0xAD,0x36
,0xD5,0x48,0x95,0xAA,0x4A,0x84,0x24,0x49
,0x14,0x48,0x8A,0x22,0x24,0x52,0x54,0xA9
,0x5A,0x5E,0xEB,0x7B,0x76,0xDB,0x64,0xA6
,0xB7,0xBB,0x6D,0xDB,0x5D,0xAD,0x56,0xAA
,0x25,0x44,0x8A,0xA5,0x24,0xAA,0x4B,0x4D
,0x2A,0x96,0xAA,0xB4,0x95,0x2A,0x5A,0xAB
,0x2A,0xD5,0xA9,0x5A,0xAD,0x55,0x9A,0x55
,0x4A,0x55,0x69,0x49,0xAA,0xA5,0x6A,0xAA
,0xCB,0x8A,0x69,0xA7,0x64,0x37,0x14,0xD9
,0x87,0x5E,0x56,0x8C,0x70,0x3F,0xB0,0x76
,0xC2,0xAA,0x6A,0xAD,0x51,0x75,0x98,0x7B
,0x0A,0xD9,0x90,0xAD,0xC0,0xBF,0x83,0x5C
,0x9B,0x61,0xCA,0x2B,0xC4,0x37,0x86,0xB6
,0x0B,0xF1,0xCD,0x0D,0x3D,0x81,0x7C,0xA6
,0x19,0xF1,0x65,0xE1,0xBA,0x81,0x3F,0xA0
,0xD6,0xFB,0x42,0x05,0xE7,0xD4,0xA7,0x09
,0x6A,0x09,0xFD,0xBB,0x70,0x05,0xFF,0x40
,0x16,0xE3,0x01,0x2F,0xFB,0xAE,0x30,0x17
,0x18,0x3B,0x5E,0x80,0xBA,0xFD,0x2A,0xFD
,0x40,0x13,0xDE,0x29,0x9F,0x71,0xB9,0xBC
,0x07,0xE1,0x81,0x3E,0xA7,0x94,0xE6,0x18
,0x27,0xDE,0xD2,0x28,0x11,0xFF,0xB8,0x01
,0x7F,0x28,0x37,0xF0,0x02,0x7B,0x17,0xFB
,0x70,0x05,0xF3,0x01,0x3F,0xEC,0x01,0x7F
,0x05,0x6A,0xBC,0x23,0x86,0xB5,0x0A,0xAB
,0xE0,0x57,0xDE,0x88,0x77,0xD4,0xA4,0x23
,0xBC,0x78,0x09,0xC8,0xE1,0xFF,0x70,0x05
,0xFB,0xC7,0x39,0xCC,0x02,0x27,0xFD,0x81
,0x7E,0x40,0x2F,0xE0,0x3F,0xE8,0x02,0xFF
,0xB4,0x07,0x5C,0x02,0x36,0xF9,0x94,0xD0
,0x97,0x7A,0x9C,0x83,0xCE,0x67,0x78,0x9B
,0x90,0x37,0x12,0xFF,0x00,0xBD,0x34,0x0B
,0xBE,0x04,0xE8,0xDC,0x05,0xFF,0x6A,0x20
,0x2F,0xC6,0xEC,0xD3,0x80,0x5F,0xF0,0x07
,0x3A,0xE1,0x5F,0xD0,0x54,0x37,0xF0,0xE2
,0x10,0xFD,0x0C,0x65,0xFB,0x83,0x0B,0xF9
,0x22,0xFB,0x01,0xF7,0x58,0x0F,0xF4,0x01
,0x5E,0xF8,0x07,0x55,0x0E,0xC3,0xBC,0x36
,0x48,0x17,0xF6,0xC5,0x54,0x28,0x5F,0x0F
,0xB8,0x8B,0x81,0x5E,0xBC,0xDD,0xA0,0x45
,0xEE,0x2F,0x48,0x90,0x9D,0x57,0xC1,0xFD
,0x00,0xC3,0x5F,0x42,0x7C,0x90,0xD4,0xEC
,0x1F,0xD8,0x06,0xB1,0xD2,0x1E,0x8F,0xF0
,0x9A,0x10,0xFE,0x0F,0xE6,0x98,0x12,0xB5
,0x5F,0xA1,0x68,0x55,0x45,0xFD,0x81,0xA4
,0xF2,0xA9,0x7B,0x03,0xEB,0x45,0x41,0x7E
,0x52,0x0D,0xBE,0xC4,0xEA,0x6A,0x55,0x7A
,0x15,0x90,0xF4,0x2B,0xF4,0x1F,0x81,0xD4
,0x2B,0xF4,0x4D,0x40,0xAA,0xAF,0xA1,0x75
,0x99,0x81,0x4F,0xC0,0xFD,0x12,0x51,0xAF
,0x85,0xF2,0x56,0x91,0x1F,0xA6,0xB2,0x0C
,0x62,0xF9,0x1F,0xC0,0xE8,0x2E,0x6A,0x9F
,0x41,0xE0,0x5D,0xE4,0x5A,0x8B,0xC2,0xC7
,0xD4,0x6A,0x0F,0x85,0xD7,0x52,0xB1,0x3E
,0x03,0xBE,0x03,0xF8,0x0A,0x97,0xDE,0x83
,0x54,0x71,0x0F,0x7A,0x1F,0xB0,0x5A,0x07
,0xF8,0x3F,0x44,0x44,0x4F,0xE1,0x7E,0x89
,0x88,0x2F,0xC3,0xF9,0x52,0x91,0x2F,0x27
,0xF4,0x60,0x2B,0x37,0x87,0xE8,0xB0,0x17
,0x35,0x4F,0xC0,0x7C,0x8C,0xD4,0x6D,0xA1
,0xAD,0xA2,0x58,0x7A,0x0B,0x85,0xEB,0x90
,0xF7,0x13,0x0E,0xCE,0xA0,0xEE,0x44,0x2B
,0x7E,0x03,0xF4,0x2A,0x45,0xFD,0x8A,0x91
,0x30,0x96,0xE4,0xDF,0xA0,0xA1,0x27,0xD4
,0x7F,0x40,0x24,0x4F,0xF0,0xFD,0x4B,0x01
,0x2F,0xE3,0xEC,0xA5,0x03,0x8F,0xC3,0xF8
,0x15,0x1B,0x1A,0x87,0xFA,0x0C,0x6C,0xB9
,0x0E,0xE5,0x34,0xD2,0x72,0x1F,0x84,0xE1
,0x7D,0xC0,0x7F,0x0B,0xA1,0x5F,0xA0,0x7B
,0x0D,0x0A,0xBF,0x41,0xF0,0x2E,0x82,0x7F
,0x03,0xF8,0x14,0x91,0xFE,0x0F,0xE9,0x10
,0x25,0xF0,0xFF,0x64,0x11,0x13,0xF0,0x7E
,0x99,0x42,0x17,0xE0,0xFE,0x15,0x0A,0x95
,0x61,0xFD,0x8A,0x05,0x5B,0x07,0xF1,0x3C
,0x16,0xAA,0x87,0xEA,0x58,0xE9,0x59,0x0D
,0xE9,0x29,0xBE,0xD4,0x1B,0xCD,0x42,0xE7
,0x90,0x3F,0x88,0x87,0x7F,0x40,0x7E,0x12
,0x96,0xDE,0x83,0xB4,0x4E,0x09,0xFB,0x07
,0xF8,0x81,0x29,0xF4,0x3F,0xB2,0x10,0x8B
,0xF8,0x3F,0xA8,0xE0,0x2B,0xA4,0xFE,0x8B
,0x44,0x27,0x45,0xFC,0x2D,0x0B,0x8A,0x27
,0xF8,0x0F,0x07,0x36,0x07,0xF0,0x7E,0x05
,0xF8,0x07,0xE5,0x30,0x7B,0x74,0x1D,0x67
,0x49,0x6B,0xD0,0x1F,0x93,0x50,0x5F,0xC4
,0x7B,0x13,0x45,0x37,0xC1,0xDE,0x23,0x20
,0xFF,0x03,0xF8,0x48,0x26,0xD6,0x4F,0xF4
,0x04,0x45,0xFC,0x3B,0x78,0x83,0x91,0xF0
,0x7F,0x0A,0xA2,0x53,0xD0,0xFE,0x07,0xC0
,0xCE,0x85,0xFC,0x1F,0x0B,0x2A,0x07,0xE8
,0x7C,0x34,0x7C,0x07,0xF0,0x7A,0x5B,0xEA
,0x07,0x65,0x70,0x67,0xF0,0x1F,0x43,0xA9
,0x57,0xE8,0x37,0x09,0xC1,0x9B,0xE0,0x7F
,0x05,0x90,0x7F,0x83,0xF6,0x48,0x22,0x7F
,0x07,0xF4,0x1C,0x81,0xFC,0x1E,0xF6,0x2A
,0x81,0xF8,0x3F,0x46,0xC1,0x91,0xB0,0x7F
,0x87,0x44,0x6E,0x81,0xFE,0x07,0x05,0xDD
,0x01,0x7E,0x9A,0x97,0x2A,0x81,0xEC,0x6C
,0xAD,0xD9,0x07,0x75,0x92,0x35,0xF4,0x0F
,0xA0,0xE0,0xDF,0xD0,0x1F,0x84,0xA2,0xDF
,0xA4,0xA5,0x98,0x87,0x7E,0x81,0xFE,0x24
,0x09,0x7D,0x17,0xEC,0x1A,0x05,0xFC,0x1F
,0x75,0x28,0x4B,0x7C,0x3F,0x12,0xD0,0xDA
,0xB0,0x7F,0x13,0xC0,0x7B,0x40,0xFF,0x0A
,0x8C,0xEF,0x00,0xFC,0x5E,0x87,0x2E,0xC0
,0xF8,0xAC,0x1F,0xF4,0x07,0xE8,0xB8,0x57
,0x7A,0x07,0xE1,0x30,0xEB,0xF4,0x0F,0xC0
,0x70,0xCF,0xE0,0x7B,0x82,0xC1,0x3F,0xA0
,0xFE,0x03,0x04,0x7D,0x17,0xEE,0x02,0x42
,0xFD,0x0F,0xD8,0xA4,0x22,0xFC,0x1F,0xC8
,0xA8,0x92,0xF8,0x1F,0xC1,0xE1,0x35,0xD0
,0x7E,0x47,0x83,0x6A,0xA0,0xFE,0x0D,0xA7
,0x1F,0x01,0xFC,0x0B,0x5E,0xEC,0x83,0xE9
,0x59,0x39,0xF9,0x07,0xD0,0xA8,0x77,0xF0
,0x9F,0x80,0xF0,0x6F,0xE9,0x36,0xC0,0xCA
,0x9F,0xA1,0xFD,0x01,0x48,0x5F,0xC3,0xF6
,0x09,0x11,0x7F,0x87,0xEC,0x1A,0x0A,0xF8
,0xA1,0x5B,0x55,0x7D,0x44,0xA2,0x37,0x55
,0x6B,0x52,0x95,0xB6,0x15,0xE2,0x57,0x65
,0x2A,0xA0,0xAF,0x6B,0x2B,0x6C,0x41,0x7C
,0xAC,0x08,0x99,0xA6,0xD7,0xCD,0x55,0xEE
,0x9C,0x22,0x22,0x5E,0xDF,0x09,0x1A,0xDA
,0x89,0x1D,0x69,0xFB,0x51,0xAC,0xB6,0x49
,0x88,0x92,0xC7,0xFD,0xA0,0x08,0xBA,0x90
,0xCD,0x57,0x3B,0xAD,0x32,0x35,0xD1,0x04
,0x95,0x09,0x5F,0x3B,0x4F,0x56,0xAD,0x2A
,0x3E,0xFA,0xD5,0x24,0x09,0x2D,0x21,0x4B
,0xBE,0xEE,0x53,0x24,0x4B,0xB5,0xBA,0x48
,0x44,0x9A,0xAA,0xA0,0x97,0x6F,0xAD,0xD6
,0xD4,0x96,0x8B,0xB0,0xAE,0x95,0x55,0x55
,0x55,0x55,0x55,0x55,0x54,0xD5,0x35,0x4A
,0xD2,0x1D,0x8B,0xE0,0x7E,0x07,0x4F,0x01
,0xFC,0x0F,0xC4,0x5E,0xC2,0xB5,0x71,0x1B
,0xC0,0xF9,0x0E,0xD4,0x5B,0x44,0xEC,0x72
,0x3F,0x81,0xF8,0x4C,0xFA,0x0F,0xC0,0xAF
,0xC0,0x7E,0x06,0xDE,0x03,0xF0,0x2F,0x81
,0xF5,0x03,0xC8,0xFC,0x07,0x3F,0x07,0xC0
,0x77,0x60,0x7F,0x03,0xF0,0x79,0x33,0x2A
,0xAA,0xA5,0x37,0x10,0xE4,0x7E,0x11,0xFC
,0x0F,0x43,0x1D,0xC0,0x6F,0x83,0x67,0xC0
,0xFD,0x05,0xF0,0x37,0x41,0xCC,0xF3,0x11
,0xFC,0x61,0xBC,0x05,0xF8,0x0B,0xE2,0x66
,0xE1,0x99,0xE0,0xBB,0x30,0xE2,0x79,0x80
,0xF3,0xC0,0xE3,0xE1,0x87,0x67,0x83,0xE6
,0x07,0xCB,0x16,0x96,0x0E,0x4F,0x9C,0x04
,0xFC,0xE0,0x79,0xE8,0x43,0xB9,0x1E,0x1C
,0xD8,0x71,0xE1,0x8F,0x12,0xDE,0x30,0x79
,0xF1,0x03,0xCF,0x84,0x1E,0xBD,0x10,0x57
,0x78,0x11,0x7F,0x10,0xEE,0x70,0x4D,0xEE
,0x11,0x1F,0xEA,0x02,0x6F,0xB4,0x11,0xF7
,0x44,0x1E,0x71,0xF0,0xC3,0x17,0x9E,0x20
,0xA7,0xE7,0x08,0x3D,0xF1,0x41,0x5F,0x68
,0x87,0x33,0xD8,0xC3,0x17,0x9E,0x30,0x29
,0xFB,0x10,0x35,0xF9,0x82,0x3E,0xB8,0xC3
,0x99,0x6E,0x70,0x49,0xF7,0x08,0x1C,0xFD
,0x88,0x17,0xFA,0x40,0xAF,0xAD,0x03,0xC6
,0x3F,0x18,0x25,0xF9,0xC2,0x0F,0x5E,0x50
,0x25,0xFD,0x01,0x3D,0xD9,0x20,0xF3,0x8D
,0xC7,0x0D,0x7C,0x70,0x29,0xF3,0x83,0x0F
,0xBC,0x08,0xED,0xB4,0x48,0xBC,0xB3,0x70
,0xC2,0xF3,0xC4,0x47,0xB5,0x83,0x47,0xDC
,0x0B,0x36,0xB3,0x0A,0xAF,0x05,0xDC,0x07
,0x37,0x4C,0x0E,0x5E,0x2A,0x39,0x3B,0x44
,0x5D,0x69,0x51,0xA5,0xE0,0x7F,0x10,0x5E
,0xB7,0x03,0x8B,0xE4,0x93,0x56,0xE4,0x27
,0x5A,0xA8,0xAA,0xBC,0x07,0xF0,0x3A,0x2F
,0xA4,0xD0,0x5E,0xA9,0x54,0x5E,0x8A,0xD2
,0xAD,0x2A,0xB1,0x72,0x4F,0x22,0xE8,0xAD
,0x53,0xA8,0xAD,0x49,0xAA,0x6D,0x45,0xAA
,0xAA,0xA5,0xA9,0x64,0x7B,0x23,0xA8,0x6D
,0x2B,0xA4,0xB5,0x15,0xC9,0x74,0x96,0xA5
,0x5A,0x56,0x8A,0xE4,0x76,0x4B,0xA4,0x6A
,0x9D,0x92,0xB4,0x57,0x25,0xB4,0x5A,0x95
,0x6A,0xAA,0x4D,0xA4,0xB6,0x4D,0x92,0x6A
,0x9D,0x89,0x69,0x55,0x95,0x69,0x55,0x55
,0x55,0x55,0x55,0x64,0xB6,0x95,0x52,0x6A
,0xAD,0x52,0xAA,0xAA,0xAA,0xAA,0xAA,0x55
,0x55,0x55,0x55,0x52,0xAD,0x53,0x54,0xAA
,0xAB,0x55,0x52,0xAA,0xAA,0xAA,0xAA,0xAA
,0xAA,0xAA,0xAA,0x72,0x1B,0xC9,0x69,0x2A
,0xAE,0xA5,0x49,0x5A,0xCA,0x95,0x55,0xA5
,0x52,0xB4,0xCD,0x2A,0xC9,0x5B,0x29,0x95
,0x55,0x55,0x55,0x52,0xB3,0x65,0x53,0x34
,0xD5,0x36,0x54,0xD4,0xD5,0x53,0x4D,0x55
,0x4C,0xB2,0xAA,0xAA,0x69,0x95,0x55,0x2D
,0x35,0x35,0x55,0x4D,0x55,0x32,0xAA,0xCB
,0x2A,0xAA,0xAA,0xAA,0x9A,0x99,0x55,0x4B
,0x69,0x59,0x2D,0x2D,0x4D,0x5A,0x55,0x54
,0xB4,0xD3,0x54,0xD5,0x53,0x56,0x55,0xA5
,0x55,0x56,0x99,0x2D,0x4D,0x34,0xB2,0xB2
,0xAA,0xAA,0xCA,0xA9,0xAB,0x4B,0x49,0x6B
,0x4D,0x52,0xB5,0x2C,0xB4,0xAA,0x96,0x96
,0xAA,0x9A,0x55,0x4C,0xB4,0xCB,0x4A,0xAA
,0x9A,0xAA,0x95,0x55,0x53,0x2D,0x54,0xB4
,0xB2,0xCB,0x94,0xC9,0xAC,0xA6,0xA9,0x55
,0x2C,0xCC,0xA5,0x9A,0xA6,0x96,0x4D,0x34
,0xB3,0x4A,0xB4,0x59,0xAA,0xA9,0x58,0xD9
,0x93,0x52,0xB2,0x6C,0xAA,0x69,0x6A,0x5A
,0x66,0x99,0x65,0x99,0xA9,0x99,0x55,0x55
,0x99,0x55,0x56,0x4D,0x54,0xD3,0x32,0xAA
,0x6A,0xA9,0x9A,0x66,0x99,0x55,0x55,0x4C
,0xCD,0x53,0x54,0xAA,0xD4,0xAA,0x99,0xAD
,0x4A,0x95,0x55,0x55,0x55,0x55,0x39,0x0F
,0xE2,0x60,0xB7,0xF4,0x08,0x5F,0xD0,0xA2
,0xBB,0x64,0x25,0xD8,0xF8,0x0F,0xC3,0x80
,0xFE,0x68,0x1F,0xAD,0x01,0xFA,0x49,0x6A
,0x5E,0xC0,0x9E,0x83,0xF0,0x70,0x7F,0x06
,0x0F,0xE0,0xA1,0xFC,0x0F,0x85,0xC9,0x55
,0xE0,0x1E,0xC1,0xF0,0x3A,0x3E,0x83,0xA7
,0xC0,0xF8,0xBC,0x0F,0xC0,0xFC,0x33,0x68
,0x3F,0x30,0x0F,0xC0,0x9B,0xF8,0x1E,0x8F
,0x03,0xE0,0xEC,0x3E,0x07,0xE0,0x7E,0x0B
,0x69,0x38,0x0F,0xE0,0xE9,0xF8,0x1F,0x0F
,0x07,0xE0,0xF0,0xDC,0x1F,0x03,0xF4,0x4A
,0xBA,0x47,0x81,0xFC,0x19,0x3F,0x07,0xC7
,0x81,0xF2,0x6C,0x1F,0x83,0x64,0x7E,0x12
,0xAE,0x50,0xB8,0x1F,0xC0,0xD3,0xF0,0x34
,0xF8,0x0F,0x57,0x41,0xF8,0x95,0x2E,0xC9
,0x2B,0xAA,0x23,0xC0,0xFE,0x0C,0x5F,0x81
,0x67,0xC0,0x7A,0xE8,0x1F,0xC2,0x33,0x66
,0x68,0x97,0x54,0x8F,0x03,0xF0,0x38,0x7E
,0x06,0xAF,0x81,0xEB,0xA0,0x3F,0xA0,0x5D
,0x95,0x54,0x9A,0xB2,0x0F,0x03,0xF0,0x70
,0x7F,0x07,0x1B,0x83,0xA5,0x78,0x2F,0x2A
,0x4A,0xF4,0x2B,0x4C,0xD5,0x07,0xE0,0xFC
,0x1C,0x0F,0xC7,0x80,0xFC,0xE0,0x3F,0x17
,0x03,0xE8,0x6E,0x82,0xBD,0x49,0x2E,0x9F
,0x03,0xF0,0xE0,0x7E,0x7A,0x05,0x5F,0xC0
,0x2A,0xFE,0x02,0xB6,0xD4,0x92,0xB6,0xA9
,0x4A,0xD3,0xC0,0xFC,0x3C,0x0F,0xAF,0x40
,0xAB,0xF4,0x44,0xAF,0xA9,0x09,0xBB,0x92
,0x2A,0xBA,0xA5,0x2B,0x4F,0x81,0xF1,0xE0
,0x6C,0xFC,0x14,0x5E,0xAD,0x22,0x9B,0xCA
,0x82,0xFA,0xA4,0x95,0xAD,0x49,0x4A,0xE9
,0x70,0x7D,0x68,0x4A,0x7D,0x50,0x2D,0xDC
,0x89,0x57,0x69,0x22,0xDD,0x94,0x2D,0x5A
,0xAA,0x2A,0xDA,0x51,0x70,0x7C,0xB0,0xC9
,0xEB,0x61,0x45,0xEA,0xC2,0xC9,0xE5,0x45
,0x67,0xA5,0x26,0xAD,0x54,0xAA,0xB4,0xAA
,0xA5,0xCA,0x67,0x92,0x1D,0x3E,0x28,0x6A
,0xF1,0x42,0xD7,0x92,0x4B,0x5D,0x51,0x29
,0xE9,0x92,0xAA,0xB5,0x2A,0xA7,0x92,0xCE
,0x30,0xD9,0xE6,0x8A,0x8E,0xAE,0x28,0xB5
,0xB2,0x92,0xAD,0x6A,0x49,0x5B,0x4C,0xAA
,0x6A,0xAA,0x64,0xCD,0x36,0x59,0x2C,0xD7
,0x29,0x15,0x6B,0x53,0x15,0x5A,0xB2,0x95
,0x56,0xAA,0x54,0xD5,0xA6,0x55,0x55,0x55
,0x53,0x92,0xCC,0xE2,0x95,0x9C,0xD2,0xA3
,0x56,0xAA,0x65,0x55,0x55,0x54,0xCA,0xAD
,0x52,0xAA,0xAA,0xAA,0xA9,0xAA,0xA9,0x66
,0x1B,0x2C,0xC6,0xA6,0xB4,0xA9,0x4D,0x58
);

my $bits_sample = 1;
my $sample_rate = $samplingFreq;

my $outfile = '18Bit.wav'; # The file where the sound is written out

my $wav = Audio::Wav->new;
my $write = $wav->write($outfile, 
			{ 
			 bits_sample => $bits_sample,
			 sample_rate => $sample_rate,
			 channels    => 1,
			}
	       );

for( my $dx = 0; $dx < @sound_data; ++$dx )
{
    my $t = (8 * $dx) * $samplingPeriod;

    #for(my $bit = 1; $bit <= ( 2 ** 7 ); $bit <<= 1) # Wrong way to play the array
    for(my $bit = ( 2 ** 7 ); $bit > 0 ; $bit >>= 1) # Right way to play the array
    {
        #$V = V( $t,  (( $bit & $sound_data[$dx] ) ? 1 : 0 ), $V);
        $V = V( (( $bit & $sound_data[$dx] ) ? 1 : 0 ), $V);
    
        # Uncomment if you want to plot the waveform as a CSV file
        #printf "%f, %f\n", $t, $V;
        #$t += $samplingPeriod;
        
        $write->write( $V );
    }
}

$write->finish;