/******************************************************************************
    SG_Big_Text.c     Copies text char into 4 custom text chars, makes it BIG.
    Copyright:        Open-Source, Jan2011, written by www.RomanBlack.com
    MCU:              P18F8527
    Dev.Board:        SmartGLCD (SmartGLCD 240x128 module)
    Oscillator:       HSPLL 32.0 MHz (8MHz xtal)
    Compiler:         MikroC v7.0 (or MikroC PRO 4.0)

  This sets the user CG ram (Character Generator ram) to ram block 3
  (blocks are 2048 bytes size), so that custom text chars can be used
  (see SG_Adv_Text.c). Then it stores BIG digit text characters in the CG
  ram, and displays these as 2x2 custom chars =  1 BIG character.
  // NOTE! GLCD is in narrow text mode (6x8 font) giving 40x16 chars.
******************************************************************************/
// Global Variables

unsigned int icount;
unsigned char txt[6];


#include "T6963C_MikroC.h"      // include this if using MikroC (older)
//#include "T6963C_MikroC_PRO.h"  // include this if using MikroC PRO

#include "SGBigNumbers.c"    // my data and functions for displaying BIG numbers


//=============================================================================
//  MAIN
//=============================================================================
void main()
{
  //-------------------------------------------------------
  // setup PIC 18F8527 for SmartGLCD pins
  CMCON = 0x07;        // turn off comparators (make all pins digital)
  ADCON0 = 0b00000001;  // ADC module on
  ADCON1 = 0b00001101;  // AN0,AN1 are adc inputs, 0v-5v range
  ADCON2 = 0b00110010;  // ADC result left justified (0-255 range)

  LATA =  0b00000000;
  TRISA = 0b00000011;   // RA0,RA1 analog inputs (TP)
  LATC =  0b00000110;   // LEDs off at start
  TRISC = 0b00000000;   // C1, C2 backlight LED
  LATG =  0b00000001;   // LED off at start
  TRISG = 0b00000000;   // G0 backlight LED
  
  LATJ  = 0b01000000;   // RJ6=FS (1=font6 0=font8), RJ5=MD
  TRISJ = 0b00000000;   // GLCD control port

  BacklightRed    = 1;     // control the GLCD backlight leds; 0=on, 1=off
  BacklightGreen  = 0;     // green ON
  BacklightBlue   = 1;

  T1CON = 0b10110001;   // TMR1 on 16bit, 1:8 prescaler, used for time testing

  //-------------------------------------------------------
  // Initialize T6963C GLCD
  //T6963C_init(240, 128, 6);   // init for MikroC PRO version
  T6963C_init(240, 128, 6, &PORTH, &PORTJ, 2, 1, 0, 4); // init for MikroC version
  T6963C_graphics(1);       // graphics mode = on
  T6963C_text(1);           // text mode = on (now both are on)
  T6963C_cursor(0);         // cursor = off

  Delay_mS(300);

  //-------------------------------------------------------
  // NOTE! GLCD is in narrow text mode (6x8 font) giving 40x16 chars.
  //-------------------------------------------------------
  // initialise the BIG numbers 
  SGBN_Setup_CG();
  SGBN_Save_CG_Chars();   // now BIG numbers are ready to use

  // write the normal sized numbers to screen
  T6963C_Write_Text("0123456789+-.'AvWCF", 0, 0, T6963C_ROM_MODE_OR);  

  // write the same thing but BIG
  SGBN_Write_Text("0123456789+-.'AvWCF", 0, 2, T6963C_ROM_MODE_OR);  

  // show a pretend voltmeter display
  SGBN_Write_Text("+13.83v", 16, 6, T6963C_ROM_MODE_OR);  

  // show a pretend thermometer display
  SGBN_Write_Text("21.5'C", 18, 9, T6963C_ROM_MODE_OR);  

  // write a couple of single characters to show coords overlapping
  SGBN_Write_Char('0',2,11,T6963C_ROM_MODE_OR);
  SGBN_Write_Char('0',3,12,T6963C_ROM_MODE_OR);
  
  //-------------------------------------------------------
  // do a loop and show how fast it draws to screen, draw all 5 big digits
  // 20 times a second.
  icount = 500;
  while(1)
  {
    Delay_mS(50);           // 1/20th of a second  
    icount++;               // 5 digit number
    WordToStr(icount,txt);  // convert it to 5 text digits
    SGBN_Write_Text(txt, 16, 12, T6963C_ROM_MODE_OR); // display it 
  }
}
//-----------------------------------------------------------------------------





