 /******************************************************************************
 * Project name:
    test_COG.c    for MikroE EasyPIC6
    (requires;) #include "RomanEXPCOG.c"
 * Copyright:
    Open-source  -  Oct 2009  -  www.RomanBlack.com
 * Description:
    This is a simple demo of my minimised routines to drive the EasyPIC6
    port expander IC and COG LCD display. My functions are small and
    can be used with the old MikroC compiler and easily converted to
    assembler etc. This has been tested on MikroC PRO 2.50 and the
    old MikroC 7.03.
    
 * Test configuration:
     MCU:             PIC16F887
                      http://ww1.microchip.com/downloads/en/DeviceDoc/41291F.pdf
     Dev.Board:       EasyPIC6
                      http://www.mikroe.com/en/tools/easypic6/
     Oscillator:      HS, 8.0000 MHz
******************************************************************************/

// global vars used in the demo
unsigned char dec_number;   // to dsplay a dec digit; 0-9
unsigned char tiny_number;  // to display a 8bit number; 0-255
unsigned int fat_number;    // to display a 16bit number; 0-65535

unsigned char text[17];   // will hold 16 chars + NULL

//-----------------------------------------------------------------------------
// this line adds my routines for port expander and COG LCD driving
#include "RomanEXPCOG.c"
//-----------------------------------------------------------------------------

//=============================================================================
//   MAIN
//=============================================================================
void main()
{
  //-------------------------------------------------------
  // 16F887 setup registers etc
  ANSEL  = 0;            // Configure AN pins as digital
  ANSELH = 0;
  CM1CON0 = 0;          // Disable comparators
  CM2CON0 = 0;          // Disable comparators

  // set the EasyPIC6 SPI pin directions before using the COG
  PORTA = 0;
  TRISA &= 0b11110011;  // set 2pins as outputs; CS, RST

  PORTC = 0;
  TRISC &= 0b11010111;  // set 2 outputs; SCK, SI, (SO is already input)

  PORTB = 0;
  TRISB = 0b00000100;   // set PORTB.F2 is button input

  //-------------------------------------------------------
  Delay_ms(500);
  RomanEXP_Init();      // init the port expander IC and LCD
  RomanEXP_Lcd_Init();

  // example of showing a message
  // (note! compiler uses RAM for text string, this eats 14 RAM!!)
  RomanEXP_Lcd_Out(0,0,"Roman_EXP_COG");

  // example of displaying a 16bit number on LCD
  fat_number = 65123;
  WordToStr(fat_number,text);
  RomanEXP_Lcd_Out(1,0,text);

  // example of displying a 8bit number
  tiny_number = 227;
  ByteToStr(tiny_number,text);
  RomanEXP_Lcd_Out(1,6,text);
  
  // example of displaying a single digit 0-9
  dec_number = 5;  
  RomanEXP_Lcd_Move(1,10);
  RomanEXP_Lcd_Char(dec_number+'0');
  
  // example of manually displaying any char
  RomanEXP_Lcd_Move(1,12);
  RomanEXP_Lcd_Char('Z');


  while(1)
  {
    // now if Button PORTB.F2 is pressed, display a string
    if(PORTB.F2)
    {
      // this looks abit clumsy in code, but unlike the
      // other string function, it uses NO ram so you can display
      // lots of text. The only cost is 3 rom per char displayed.

      RomanEXP_Lcd_Move(0,0);   // move top line, first char
      RomanEXP_Lcd_Char('T');   // just display each char in turn
      RomanEXP_Lcd_Char('h');
      RomanEXP_Lcd_Char('i');
      RomanEXP_Lcd_Char('s');
      RomanEXP_Lcd_Char(' ');
      RomanEXP_Lcd_Char('U');
      RomanEXP_Lcd_Char('s');
      RomanEXP_Lcd_Char('e');
      RomanEXP_Lcd_Char('s');
      RomanEXP_Lcd_Char(' ');
      RomanEXP_Lcd_Char('N');
      RomanEXP_Lcd_Char('o');
      RomanEXP_Lcd_Char(' ');
      RomanEXP_Lcd_Char('R');
      RomanEXP_Lcd_Char('a');
      RomanEXP_Lcd_Char('m');
    }
  }
}
//-----------------------------------------------------------------------------


